<?php

namespace App\Http\Controllers\Merchant;

use App\Http\Controllers\Controller;
use App\Http\Requests\Order\StoreOrderRequest;
use App\Models\Customer;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\VehicleType;
use DataTables;
use Illuminate\Database\QueryException;
use Session;

class OrderController extends Controller
{
    public function __construct()
    {
        $this->orderStatus = ["1"=>"Pending","2" => "In Transit", "3" => "In Hub","4" => "Out for Delivery","5"=>"Delivered"];  
        $this->orderTypes = ["1" => "Normal","2" => "Express"];      
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            
            // $results = Order::get();
            $results = Order::CreatedByMerchantUser()
                              ->get();

            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("order_id", function ($data) {
                    if (empty($data->order_id)) {
                        return "N/A";
                    }
                    return $data->order_id;
                })
               
                ->addColumn("merchant_id", function ($data) {
                    if (empty($data->merchant_id)) {
                        return "N/A";
                    }
                    return $data->merchant_id;
                })
                ->addColumn("customer_id", function ($data) {
                    if (empty($data->customer_id)) {
                        return "N/A";
                    }
                    return $data->customer_id;
                })
                ->addColumn("action", function ($data) {
                    $btn = '<a class="btn btn-primary btn-xs" href="' . route('merchant.order.show', $data->id) . '" data-toggle="tooltip" data-placement="top" title="View Order"><i class="fa fa fa-eye"></i></a>&nbsp;';
                    $btn .=
                        '<a class="btn btn-info btn-xs" href="' .
                        route("merchant.order.edit", $data->id) .
                        '" data-toggle="tooltip" data-placement="top" title="Edit Order"><i class="fa fa-edit"></i> Edit</a>&nbsp;';
                    $btn .=
                        '<a class="btn btn-danger btn-xs deleteorder" href="javascript:;" data-order="' .
                        $data->id .
                        '" data-toggle="tooltip" data-placement="top" title="Delete Order"><i class="fa fa-trash"></i> Delete</a>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }

        $data["title"] = "Manage Order";

        return view("pages.merchant.order.list", $data); 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data["status"] = $this->orderStatus;
        $data["order_types"] = $this->orderTypes; 
        $data["customers"]  = Customer::where('created_by',\Auth::user()->id)->get();
        $data["vehicle_types"] = VehicleType::pluck("name","id");
        $data["vehicle_types"]->prepend("Select Vehicle", "");
        return view('pages.merchant.order.create', $data);
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreOrderRequest $request)
    {
        $customer_type = $request->customer_type;
        if($customer_type == 1)
        {
            $is_exist = Customer::checkExistPhone($request->phone);
            if($is_exist)
            {
                $customer = Customer::getCustomerPhoneInfo($request->phone);              
                $arr_merchant_ids = Customer::getUniqueArrayMerchantIds($customer);
                $new_merchant_ids = Customer::getStringMerchantIds($arr_merchant_ids);
                $updateCustomer = Customer::updateCustomer($request,$new_merchant_ids);
                if($updateCustomer)
                {
                    $order = Order::createOrder($request,$customer->id);
                    if($order)
                    {
                        return redirect()
                        ->route("merchant.order.index")
                        ->with("success", "Order created successfully!");
                    }
                    else
                    {
                        $msg = "Insertion Error - exist customer new order";
                        return redirect()
                        ->route("merchant.order.index")
                        ->with("failed", $msg);    
                    }                        
                }
                else
                {
                    $msg = "update Error - exist customer";
                        return redirect()
                        ->route("merchant.order.index")
                        ->with("failed", $msg);    
                }
            }
            else
            {
                $customer_id = Customer::createCustomer($request);
                if($customer_id)
                {
                    $order_id = Order::createOrder($request,$customer_id);
                    if($order_id)
                    {
                        return redirect()
                        ->route("merchant.order.index")
                        ->with("success", "Order created successfully!");
                    }
                    else
                    {
                        return redirect()
                        ->route("merchant.order.index")
                        ->with("failed", 'Insert Error - new order');
                    }
                }
                else
                {
                    return redirect()
                    ->route("merchant.order.index")
                    ->with("failed", 'Insert Error - new customer');
                }   
            }
        }
        else
        {
            $customer_id = $request->customer_id;
            $order_id = Order::createOrder($request,$customer_id);
            if($order_id)
            {
                return redirect()
                        ->route("merchant.order.index")
                        ->with("success", "Order created successfully!");
            }
            else
            {
                return redirect()
                ->route("merchant.order.index")
                ->with("failed", 'Insert Error - new customer');
            }
                
        }
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data["status"] = $this->orderStatus;
        $data["order_types"] = $this->orderTypes; 
        $data["customers"]  = Customer::get();
        $data["orderInfo"] = Order::find($id);
        $data["vehicle_types"] = VehicleType::pluck("name","id");
        $data["vehicle_types"]->prepend("Select Vehicle", "");
        return view('pages.merchant.order.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function customer(Request $request)
    {
        $customer_id =  $request->customer_id;
        $customer = Customer::where('id', $customer_id)->first();
        return view('pages.merchant.order.customer_detail', compact('customer'));       
    }
}
