@extends('layouts.layout-admin')
@section('styles')
<!-- Select2 -->
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
.control-label{
    text-align: right;
}
.hide{
    display: none;
}
</style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Supplier Details') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Supplier Details') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Supplier Details') }}</h3>                  
                  {{-- <span class="tools" style="float:right">
                    <a href="{{ route('user.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                  </span> --}}
                </div>
                <!-- /.card-header -->
                <div class="card-body"> 
                    <form class="form-horizontal" id="supplier_edit_form" autocomplete="off" role="form" enctype="multipart/form-data" method="POST" action="#">
                        @csrf
                        <div class=" row" style="text-align:center;">
                            <div class="col-sm-12" >
                                <label class="control-label">{{ __('Supplier Details') }}</label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group row @error('supplier_company') has-error @enderror">
                                    <label for="supplier_company" class="col-sm-4 control-label">{{ __('Supplier Company') }} <span class="text-danger">{{ __('*') }}</span></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="supplier_company" id="supplier_company" value="" placeholder="Supplier Company">
                                        @if($errors->has('supplier_company'))
                                        <p class="text-danger">{{ $errors->first('supplier_company') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('supplier_code') has-error @enderror">
                                    <label for="supplier_code" class="col-sm-4 control-label">{{ __('Supplier Code') }} <span class="text-danger">{{ __('*') }}</span></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="supplier_code" id="supplier_code" value="" placeholder="Supplier Code">
                                        @if($errors->has('supplier_code'))
                                            <p class="text-danger">{{ $errors->first('supplier_code') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group row @error('contractor_first_name') has-error @enderror">
                                    <label for="contractor_first_name" class="col-sm-4 control-label">{{ __('Contractor First Name') }} <span class="text-danger">{{ __('*') }}</span></label>
                                    <div class="col-sm-2">
                                        {!! Form::select('name_prefix', $namePrefix, null, ['class' => 'form-control m-bot15']) !!}
                                        @if($errors->has('status'))
                                            <p class="text-danger">{{ $errors->first('name_prefix') }}</p>
                                        @endif
                                    </div>
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" name="contractor_first_name" id="contractor_first_name" value="" placeholder="Contractor First Name">
                                        @if($errors->has('contractor_first_name'))
                                        <p class="text-danger">{{ $errors->first('contractor_first_name') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('contractor_last_name') has-error @enderror">
                                    <label for="contractor_last_name" class="col-sm-4 control-label">{{ __('Contractor Last Name') }} <span class="text-danger">{{ __('*') }}</span></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="contractor_last_name" id="contractor_last_name" value="" placeholder="Contractor Last Name">
                                        @if($errors->has('contractor_last_name'))
                                            <p class="text-danger">{{ $errors->first('contractor_last_name') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group row @error('supplier_ref') has-error @enderror">
                                    <label for="supplier_ref" class="col-sm-4 control-label">{{ __('Supplier Ref') }}</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="supplier_ref" id="supplier_ref" value="" placeholder="Supplier Ref">
                                        @if($errors->has('supplier_ref'))
                                        <p class="text-danger">{{ $errors->first('supplier_ref') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('license_number') has-error @enderror">
                                    <label for="license_number" class="col-sm-4 control-label">{{ __('License No') }}</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="license_number" id="license_number" value="" placeholder="License No">
                                        @if($errors->has('license_number'))
                                            <p class="text-danger">{{ $errors->first('license_number') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="form-group row @error('address') has-error @enderror">
                                    <label for="address" class="col-sm-2 control-label">{{ __('Address') }}</label>
                                    <div class="col-sm-10 col-sm-offset-2">
                                        <textarea class="form-control" name="address" id="address" rows="4"></textarea>
                                        @if($errors->has('address'))
                                            <p class="text-danger">{{ $errors->first('address') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group row @error('country') has-error @enderror">
                                    <label for="country" class="col-sm-4 control-label">{{ __('Country') }} </label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="country" id="country1" value="" placeholder="Country">
                                        @if($errors->has('country'))
                                            <p class="text-danger">{{ $errors->first('country') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('state') has-error @enderror">
                                    <label for="state" class="col-sm-4 control-label">{{ __('State') }} </label>
                                    <div class="col-sm-8">
                                    
                                        <input type="text" class="form-control" name="state" id="state" value="" placeholder="State">
                                        @if($errors->has('state'))
                                            <p class="text-danger">{{ $errors->first('state') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('city') has-error @enderror">
                                    <label for="city" class="col-sm-4 control-label">{{ __('City') }} </label>
                                    <div class="col-sm-8">
                            
                                        <input type="text" class="form-control" name="city" id="city" value="" placeholder="City">
                                        @if($errors->has('city'))
                                            <p class="text-danger">{{ $errors->first('city') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('postal_code') has-error @enderror">
                                    <label for="postal_code" class="col-sm-4 control-label">{{ __('Postal Code') }} </label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="postal_code" id="postal_code" value="" placeholder="Postal Code">
                                        @if($errors->has('postal_code'))
                                            <p class="text-danger">{{ $errors->first('postal_code') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group row @error('phone') has-error @enderror">
                                    <label for="phone" class="col-sm-4 control-label">{{ __('Phone Number') }} </label>
                                    <div class="col-sm-8">
                                        <input type="phone" class="form-control" name="phone" id="phone" value="" placeholder="Phone">
                                        @if($errors->has('phone'))
                                            <p class="text-danger">{{ $errors->first('phone') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group row @error('email') has-error @enderror">
                                    <label for="email" class="col-sm-4 control-label">{{ __('Email') }} </label>
                                    <div class="col-sm-8">
                                        <input type="email" class="form-control" name="email" id="email" value="" placeholder="Email">
                                        @if($errors->has('email'))
                                            <p class="text-danger">{{ $errors->first('email') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>   
                        </div>

                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group row @error('pan_number') has-error @enderror">
                                    <label for="pan_number" class="col-sm-4 control-label">{{ __('Pan Number') }}</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="pan_number" id="pan_number" maxlength="13" value="" placeholder="Pan Number" />
                                        @if($errors->has('pan_number'))
                                            <p class="text-danger">{{ $errors->first('pan_number') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">      
                                <div class="form-group row @error('tan_number') has-error @enderror">
                                    <label for="tan_number" class="control-label col-sm-4">{{ __('Tan Number') }} </label></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="tan_number" id="tan_number" maxlength="13" value="" placeholder="Tan Number" />
                                        @if($errors->has('tan_number'))
                                            <p class="text-danger">{{ $errors->first('tan_number') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group row @error('service_tax_number') has-error @enderror">
                                    <label for="service_tax_number" class="col-sm-4 control-label">{{ __('Service Tax No') }}</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="service_tax_number" id="service_tax_number" maxlength="13" value="" placeholder="Service Tax No" />
                                        @if($errors->has('service_tax_number'))
                                            <p class="text-danger">{{ $errors->first('service_tax_number') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">      
                                <div class="form-group row @error('iata_no') has-error @enderror">
                                    <label for="iata_no" class="control-label col-sm-4">{{ __('IATA No') }} </label></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="iata_no" id="iata_no" maxlength="13" value="" placeholder="IATA No" />
                                        @if($errors->has('iata_no'))
                                            <p class="text-danger">{{ $errors->first('iata_no') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group row @error('tta_no') has-error @enderror">
                                    <label for="tta_no" class="col-sm-4 control-label">{{ __('TTA No') }}</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="tta_no" id="tta_no" maxlength="13" value="" placeholder="TTA No" />
                                        @if($errors->has('tta_no'))
                                            <p class="text-danger">{{ $errors->first('tta_no') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">      
                                <div class="form-group row @error('fax_number') has-error @enderror">
                                    <label for="fax_number" class="control-label col-sm-4">{{ __('Tax No') }} </label></label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" name="fax_number" id="fax_number" maxlength="13" value="" placeholder="Tax No" />
                                        @if($errors->has('fax_number'))
                                            <p class="text-danger">{{ $errors->first('fax_number') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="offset-sm-2 col-sm-10">
                                <div class="form-check">
                                    <input type="checkbox" class="form-check-input" id="hotel_confirmation">
                                    <label class="form-check-label" for="hotel_confirmation">Hotel Confirmation</label>
                                </div>
                            </div>
                          
                            <div class="col-sm-6">
                                <div class="form-group row @error('status') has-error @enderror">
                                    <label for="status" class="control-label col-sm-4"> {{ __('Status') }} </label>                                
                                    <div class="col-sm-8">
                                        {!! Form::select('status', $status, null, ['class' => 'form-control m-bot15']) !!}
                                        @if($errors->has('status'))
                                            <p class="text-danger">{{ $errors->first('status') }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row" style="text-align: center;">
                            <div class="col-sm-12">
                                <input type="hidden" name="user_id" value=""/>
                                <button type="submit" id="supplierEditBtn" class="btn btn-primary">{{ __('Update Details') }}</button>
                                <a href="{{ route('supplier.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
      </div>
    </div>
</section>
@endsection
@section('scripts')
@endsection