@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Supplier') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Supplier') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Suppliers') }}</h3>
                  <a href="{{ route('supplier.create') }}" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Supplier') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                  
                    <table class="table table-bordered table-striped" id="supplier_table">
                        <thead>
                            <tr>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Supplier Company') }}</th>
                                <th>{{ __('Supplier Code') }}</th>
                                <th>{{ __('Email') }}</th>
                                <th>{{ __('Approve Status') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var table = $('#supplier_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('supplier.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'contractor_first_name', name: 'contractor_first_name'},
            {data: 'supplier_company', name: 'supplier_company'},
            {data: 'supplier_code', name: 'supplier_code'},
            {data: 'email', name: 'email'},
            {data: 'is_approved', name: 'is_approved'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletesupplier').on('click',function(){
              var x = confirm("Do you want to delete the supplier?");
              if(x == true) { 
              var supplierid = $(this).data('supplier'); 
                  $.ajax({
                      url: "{{ route('delete-supplier') }}",
                      data: { "id": supplierid },
                      type: "post",
                      dataType: "json",
                      success: function (data) {
                        window.location.reload();
                      }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
function getChangeApproveStatusForm(user_id, is_approved){
    $('#myModal' ).modal();
    $('#modal_footer' ).html('');
    $('#modal_title' ).html( 'Change Approve Status Form' );
    $.ajax({
        url: "{{ route('supplier.getChangeApproveStatusForm') }}",
        data: { "user_id": user_id, "is_approved": is_approved },
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_body' ).html(html);
        }
    });
}

function changeApproveStatus()
{
    var is_approved = $('#change_approve_status_form #is_approved').val();
    var user_id     = $('#change_approve_status_form #user_id').val();
    $.ajax({
        url: "{{ route('supplier.changeApproveStatus') }}",
        data: { "user_id": user_id,"is_approved": is_approved},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#changeApproveStatusBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#changeApproveStatusBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#supplier_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        }
    });
}
function ajaxSaveService(user_id){
    $.ajax({
        url: "{{ route('supplier.serviceForm') }}",
        data: {"user_id": user_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Supplier Service' );
            $('#modal_footer' ).html('');
        }
    });
}
function saveService(user_id)
{
    var service_name = [];
    $('.services:checked').each(function(){
        service_name.push($(this).val());
    })
    if(service_name == ""){
        toastr.error('Please select minimum one service.','Error');
        return false;
    }
    $.ajax({
        url: "{{ route('supplier.saveService') }}",
        data: { "user_id": user_id,"service_name": service_name},
        type: "post",
        dataType: "json",
        beforeSend: function() {
            $("#serviceSaveBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#serviceSaveBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#save_service_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#supplier_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
@endsection