<?php

namespace App\Http\Controllers\API\V1;

use App\Http\Controllers\API\V1\BaseController as BaseController;
use Illuminate\Http\Request;
use Auth;
use App\Events\LoginHistory;
use App\Models\Driver;

class DriverLoginController extends BaseController
{
    public function login(Request $request)
    {
        // if(Auth::guard('driver')->attempt(['email' => $request->email, 'password' => $request->password])){ 
        if(Auth::attempt(['email' => $request->email, 'password' => $request->password, 'is_approved' => 1])){           
            $user = Auth::user();
            $user->last_login_at = date('Y-m-d H:i:s');
            $user->last_login_ip = $request->getClientIp();
            $user->save();
           
            event(new LoginHistory($user));

            $driverInfo = Driver::where('user_id',$user->id)->first();

            $res['token'] =  $user->createToken('suhu')->accessToken; 
            $success['email'] =  $user->email;
            $success['user_name'] =  $user->user_name;
            $success['phone'] =  $user->phone;
            $success['user_id'] =  $user->id;
            $success['first_name'] =  ($driverInfo)?$driverInfo->first_name:'';
            $success['last_name'] =  ($driverInfo)?$driverInfo->last_name:'';
            $success['address_book_id '] =  ($driverInfo)?$driverInfo->address_book_id :'';
            $success['ic_number'] =  ($driverInfo)?$driverInfo->ic_number:'';
            $success['ic_image'] =  ($driverInfo)?$driverInfo->ic_image:'';
            $success['license_number'] =  ($driverInfo)?$driverInfo->license_number:'';
            $success['carplate_number'] =  ($driverInfo)?$driverInfo->carplate_number:'';
            $success['car_model'] =  ($driverInfo)?$driverInfo->car_model:'';
            $success['insurance_expiry_date'] =  ($driverInfo)?$driverInfo->insurance_expiry_date:'';
            $success['vehicle_type'] =  ($driverInfo)?$driverInfo->vehicle_type:'';
            $success['insurance_company'] =  ($driverInfo)?$driverInfo->insurance_company:'';
            $res['user_info'] = $success;
            return $this->sendResponse($res, 'User login successfully.');
        } 
        else
        { 
            return $this->sendError('Unauthorised.', ['error'=>'Unauthorised']);
        } 
    }
}
