<?php

namespace App\Http\Controllers\API\V1;

// use App\Http\Controllers\Controller;
use App\Http\Controllers\API\V1\BaseController as BaseController;
use App\Models\ApproveStatus;
use App\Models\Country;
use App\Models\Hub;
use Illuminate\Http\Request;
use App\Models\PostalCode;
use App\Models\VehicleType;
use DB;

class MasterController extends BaseController
{
    public function __construct()
    {
        $this->customerStatus = ["1" => "Active", "2" => "Inactive"];
        $this->driverStatus = ["1" => "Active", "2" => "Inactive"];
        $this->defaultPassword = "Suhu@123";
        $this->hubStatus = ["1" => "Active", "2" => "Inactive"];
        $this->merchantStatus = ["1" => "Active", "2" => "Inactive"];
        $this->orderStatus = ["1"=>"Pending","2" => "In Transit", "3" => "In Hub","4" => "Out for Delivery","5"=>"Delivered"];  
        $this->orderTypes = ["1" => "Normal","2" => "Express"];         
        $this->priceTypes = ["1" => "Amount","2" => "Percent"]; 
        $this->productCategoryStatus = ["1" => "Active", "2" => "Inactive"];
        $this->userStatus = ["1" => "Active", "2" => "Inactive"];
        $this->vehicleStatus = ["1" => "Active", "2" => "Inactive"];
        $this->vehicleTypeStatus = ["1" => "Active", "2" => "Inactive"];
    }
    public function listMasterData(Request $request)
    {
        $approveStatuses = ApproveStatus::get();
        foreach($approveStatuses as $approveStatus)
        {
            $success['approveStatus'][] = array("key"=>$approveStatus->approve_status_value,"value" =>$approveStatus->approve_status_name );
        }
        // $success['approveStatuses'] = ApproveStatus::get()->pluck('approve_status_name','approve_status_value');
        $hubs = Hub::get();
        foreach($hubs as $hub)
        {
            $success['hubs'][] = array("key"=>$hub->hub_id,"value" =>$hub->hub_name );
        }
        // $success['hubs'] = Hub::get()->toArray();
        $vehicleTypes = VehicleType::get();
        foreach($vehicleTypes as $vehicleType)
        {
            $success['vehicleTypes'][]  = array("key"=>$vehicleType->vehicle_type_id,"value" =>$vehicleType->name );
        }            
        // $success['vehicleTypes'] = VehicleType::get()->pluck('name','vehicle_type_id');            
        $countries= Country::get();   
        foreach($countries as $country)
        {
            $success['countries'][]  = array("key"=>$country->countries_id,"value" =>$country->country_code );
        }          
        // $success['countries'] = Country::get()->pluck('country_code','countries_id');            
        $orderTypes= $this->orderTypes;
        foreach($orderTypes as $key => $orderType)
        {
            $success['orderTypes'][]  = array("key"=>$key,"value" =>$orderType );
        } 
        // $success['orderTypes'] = $this->orderTypes;
        $priceTypes = $this->priceTypes;
        foreach($priceTypes as $key => $priceType)
        {
            $success['priceTypes'][]  = array("key"=>$key,"value" =>$priceType );
        } 
        // $success['priceTypes'] = $this->priceTypes;
        $productCategoryStatus = $this->productCategoryStatus;
        foreach($productCategoryStatus as $key => $productCategoryStat)
        {
            $success['productCategoryStatus'][]  = array("key"=>$key,"value" =>$productCategoryStat );
        } 
        // $success['productCategoryStatus'] = $this->productCategoryStatus;
        $userStatus=  $this->userStatus;
        foreach($userStatus as $key => $userStat)
        {
            $success['userStatus'][]  = array("key"=>$key,"value" =>$userStat);
        }
        // $success['userStatus']  =  $this->userStatus ;
        $vehicleStatus = $this->vehicleStatus;
        foreach($vehicleStatus as $key => $vehicleStat)
        {
            $success['vehicleStatus'][]  = array("key"=>$key,"value" =>$vehicleStat);
        }
        // $success['vehicleStatus'] = $this->vehicleStatus;
        $vehicleTypeStatus = $this->vehicleTypeStatus;
        foreach($vehicleTypeStatus as $key => $vehicleTypeStat)
        {
            $success['vehicleTypeStatus'][]  = array("key"=>$key,"value" =>$vehicleTypeStat);
        }
        // $success['vehicleTypeStatus'] = $this->vehicleTypeStatus;
        $orderStatuses = $this->orderStatus;
        foreach($orderStatuses as $key => $orderStat)
        {
            $success['orderStatuses'][]  = array("key"=>$key,"value" =>$orderStat);
        }
        // $success['orderStatuses'] = $this->orderStatus;
        $customerStatuses = $this->customerStatus;
        foreach($customerStatuses as $key => $customerStat)
        {
            $success['customerStatuses'][]  = array("key"=>$key,"value" =>$customerStat);
        }
        // $success['customerStatuses'] = $this->customerStatus;
        $success['defaultPassword'] = $this->defaultPassword;  
        return $this->sendResponse($success, 'Master Data.',200);
    }
}
