<?php

namespace App\Http\Controllers\API\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\API\V1\BaseController as BaseController;
use App\Models\FirebaseUid;
use App\Models\Vehicle;
use App\Models\User;
use App\Models\UserDevice;
use Illuminate\Database\QueryException;
use Validator;
use Auth;

class VehicleController extends BaseController
{
    public function addVehicle(Request $request)
    {
        $verify_uid = FirebaseUid::verifyFirebaseUid($request);
        if($verify_uid)
        {
            $validator = Validator::make($request->all(), [
                "driver_id" => "required",
                // "user_id" => "required",
                "reg_number" => "required|unique:vehicles,reg_number",
                "model_number" => "required",
                "road_tax_number" => "required",
                "road_tax_expiry_date" => "required",
                "insurance_company" => "required",
                "insurance_number" => "required|unique:vehicles,insurance_number",
                "insurance_expiry_date" => "required",
                "vehicle_type" => "required",
                "status" => "required",
            ]);
            
            if($validator->fails()){
                return $this->sendError('Validation Error.', $validator->errors(),422);       
            }
            // $input = $request->all();
            try
            {
                // $device = UserDevice::registerDevices($request,$request->user_id);
                // $vehicle = Vehicle::create($input);
                $vehicle = Vehicle::create([
                    "driver_id" =>$request->driver_id,
                    "reg_number" => $request->reg_number,
                    "model_number" => $request->model_number,
                    "road_tax_number" => $request->road_tax_number,
                    "road_tax_expiry_date" => $request->road_tax_expiry_date,
                    "insurance_company" => $request->insurance_company,
                    "insurance_number" => $request->insurance_number,
                    "insurance_expiry_date" => $request->insurance_expiry_date,
                    "vehicle_type" => $request->vehicle_type,
                    "status" => $request->status
                ]);
                if($vehicle)
                {

                    $updateUserRegisterPage = User::updateRegisterPage(auth()->user()->id,3);//update set preferred area page

                    $success['vehicle_id'] =  $vehicle->vehicle_id;
                    $success['reg_number'] =  $vehicle->reg_number;
                    $success['user_id'] =  auth()->user()->id;
                    $success['approve_status'] = 'Pending'; 
                    $success['redirect_to'] = 'register_third_page';
                    $success['redirect_url'] = URL('api/v1/list-near-by-preferred-area'); 
                    return $this->sendResponse($success, 'Vehicle register successfully.');
                }else{
                    return $this->sendError('Insertion error', ['error'=>'Adding Vehicle Failed'],400);
                }
            }
            catch(QueryException $ex) 
            {
                $query_error = 'Insert Error';
                return $this->sendError($query_error, ['error'=>'Adding Vehicle Failed'],400);                
            }

        }
        else
        {
            $failed = [
                'redirect_to' => 'verify_firebase_token_page',
                'redirect_url' => URL('api/v1/verify-firebase-token')
              ];
              return $this->sendError($failed, "Not Verified. New User",400);
        }
    }
    public function updateVehicle(Request $request)
    {
        $verify_uid = FirebaseUid::verifyFirebaseUid($request);
        if($verify_uid)
        {

            $validator = Validator::make($request->all(), [
                "driver_id" => "required",
                // "user_id" => "required",
                "reg_number" => "required|unique:vehicles,reg_number,".$request->vehicle_id.",vehicle_id",
                "model_number" => "required",
                "road_tax_number" => "required",
                "road_tax_expiry_date" => "required",
                "insurance_company" => "required",
                "insurance_number" => "required|unique:vehicles,insurance_number,".$request->vehicle_id.",vehicle_id",
                "insurance_expiry_date" => "required",
                "vehicle_type" => "required",
                "status" => "required",
            ]);
            
            if($validator->fails()){
                return $this->sendError('Validation Error.', $validator->errors(),422);       
            }

            try
            {
                $vehicle = Vehicle::find($request->vehicle_id);   
                $vehicle->driver_id = $request->driver_id;
                $vehicle->reg_number = $request->reg_number;
                $vehicle->model_number = $request->model_number;
                $vehicle->road_tax_number = $request->road_tax_number;
                $vehicle->road_tax_expiry_date = $request->road_tax_expiry_date;
                $vehicle->insurance_company = $request->insurance_company;
                $vehicle->insurance_number = $request->insurance_number;
                $vehicle->insurance_expiry_date = $request->insurance_expiry_date;
                $vehicle->vehicle_type = $request->vehicle_type;
                $vehicle->status = $request->status;
                $vehicle->save();  

                $updateUserRegisterPage = User::updateRegisterPage(auth()->user()->id,3);//update set preferred area page

                $success['vehicle_id'] =  $vehicle->vehicle_id;
                $success['reg_number'] =  $vehicle->reg_number;
                $success['user_id'] =  auth()->user()->id;
                $success['approve_status'] = 'Pending'; 
                $success['redirect_to'] = 'register_third_page';
                $success['redirect_url'] = URL('api/v1/list-near-by-preferred-area'); 
                return $this->sendResponse($success, 'Vehicle register successfully.');


            }
            catch(QueryException $ex)
            {
                return $this->sendError('update error', ['error'=>$ex],400);
            }
        }
        else
        {
            $failed = [
                'redirect_to' => 'verify_firebase_token_page',
                'redirect_url' => URL('api/v1/verify-firebase-token')
            ];
            return $this->sendError($failed, "Not Verified. New User",400);
        }

    }
}
