<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\AddressBook;
use App\Models\Merchant;
use App\Models\ProductCategory;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Database\QueryException;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    // protected $redirectTo = RouteServiceProvider::HOME;
    protected $redirectTo = RouteServiceProvider::DASHBOARD;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }

    public function showMerchantRegistrationForm()
    {
        $data["product_category"] = ProductCategory::get();
        return view('auth.merchant-register',$data);
    }

    public function merchantRegister(Request $request)
    {
        $request->validate([
            "first_name" => "required",
            "last_name" => "required",
            "email" => "required|email|unique:users,email",
            "address_1" => "required",            
            "postal_code_1" => "required",           
            "city_1" => "required",           
            "state_1" => "required",           
            "country_1" => "required",           
            "phone" => "required|unique:users,phone",
            "logo" => "required",
            "ssm_number" => "required",
            "company_name" => "required",
            "company_email" => "required",
            "company_phone" => "required",
            "product_category" => "required",
            "product_images" => "required",
            "password" => "required",
            "password_confirm" => "required",            
        ]);
        if($request->password != $request->password_confirm)
        {
            return redirect()
                ->route("merchant.register")
                ->with("failed", "New and Confirm Passwords are not matched..!");
        }
        $password = Hash::make($request->password);

        if ($request->hasFile("logo")) {
           
            $logoname =
                time() .
                "_logo." .
                $request
                    ->file("logo")
                    ->getClientOriginalExtension();
            $request
                ->file("logo")
                ->move(
                    base_path() . "/public/uploads/merchant_logos/",
                    $logoname
                );
        } else {
            $logoname = "";
        }

        $images = [];
        if($request->hasfile('product_images'))
        {
            foreach($request->file('product_images') as $file)
            {
                $imageName =
                time() .rand(100,999).
                "_product_images." .
                $file->getClientOriginalExtension();
                // $name = time().rand(1,100).'.'.$file->extension();
                $file->move(base_path() . "/public/uploads/product_images/", $imageName);  
                $images[] = $imageName;  
            }
        }
        $product_category = isset($request->product_category)?(implode(',',$request->product_category)):'';
        $str_images = isset($images)? (implode('~',$images)):'';

        try
        {
            $register = 1;//register page param
            $user_id = User::createUser($request,'MERCHANT',$register);
            
            if($user_id)
            {
                try
                {                                     
                    $merchant = Merchant::create([
                        "user_id" => $user_id,
                        "first_name" => trim($request->first_name),                                    
                        "last_name" => trim($request->last_name),
                        "logo" => $logoname,
                        "ssm_number" => trim($request->ssm_number),
                        "company_name" => trim($request->company_name),
                        "company_email" => trim($request->company_email),
                        "company_phone" => trim($request->company_phone),
                        "product_category" => $product_category,
                        "product_images" => "$str_images",
                        "created_by" => $user_id
                    ]);  
                    $userData['address_type'] = 2;//Commercial
                    $userData['user_id'] = $user_id;
                    $userData['merchant_id'] = $merchant->merchant_id;

                     $address1['address'] = ($request->address_1)?$request->address_1:''; 
                     $address1['address_line_1'] = ($request->address_line_11)?$request->address_line_11:''; 
                     $address1['address_line_2'] = ($request->address_line_12)?$request->address_line_12:''; 
                     $address1['postal_code'] = ($request->postal_code_1)?$request->postal_code_1:''; 
                     $address1['city'] = ($request->city_1)?$request->city_1:''; 
                     $address1['district'] = ($request->district_1)?$request->district_1:''; 
                     $address1['state'] = ($request->state_1)?$request->state_1:''; 
                     $address1['country'] = ($request->country_1)?$request->country_1:''; 
                     $address1['latitude'] = ($request->latitude_1)?$request->latitude_1:''; 
                     $address1['longitude'] = ($request->longitude_1)?$request->longitude_1:''; 
                     $commAddrId_1 = AddressBook::createAddress($address1,$userData,$register);
 
                     $address2['address'] = ($request->address_2)?$request->address_line_2:''; 
                     $address2['address_line_1'] = ($request->address_line_21)?$request->address_line_21:''; 
                     $address2['address_line_2'] = ($request->address_line_22)?$request->address_line_22:''; 
                     $address2['postal_code'] = ($request->postal_code_2)?$request->postal_code_2:''; 
                     $address2['city'] = ($request->city_2)?$request->city_2:''; 
                     $address2['district'] = ($request->district_2)?$request->district_2:''; 
                     $address2['state'] = ($request->state_2)?$request->state_2:''; 
                     $address2['country'] = ($request->country_2)?$request->country_2:''; 
                     $address2['latitude'] = ($request->latitude_2)?$request->latitude_2:''; 
                     $address2['longitude'] = ($request->longitude_2)?$request->longitude_2:''; 
                     $commAddrId_2 = AddressBook::createAddress($address2,$userData,$register);  

                    $update = Merchant::updateAddressBookId($merchant->merchant_id,$commAddrId_1,$commAddrId_2);
                   
                }
                catch(QueryException $ex) 
                {
                    return redirect()
                    ->route("merchant.register")
                    ->with("failed", "Insertion Error");                 
                }
            }
        }
        catch(QueryException $ex) 
        {
            return redirect()
            ->route("merchant.register")
            ->with("failed","User Insertion Error");                 
        } 
       
        return redirect()
        ->route("merchant.register")
        ->with("success", "Merchant Registered successfully!");


    }
}
