<?php

namespace App\Http\Requests\Hub;

use Illuminate\Foundation\Http\FormRequest;

class StoreHubRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create hub');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "hub_name" => "required",
            "manager_name" => "required",
            "country_code_id"=>"required",
	     // "phone" => "required",
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14",
            "address" => "required",           
            "postal_code" => "required",           
            "city" => "required",           
            "state" => "required",           
            "country" => "required",
            "status" => "required",          
        ];
    }
}
