<?php

namespace App\Http\Requests\Merchant;

use Illuminate\Foundation\Http\FormRequest;

class UpdateMerchantRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('edit merchant');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            "first_name" => "required",
            "last_name" => "required",
            "email" => "required|unique:users,email,".$this->user_id,
            "address_1" => "required",           
            "postal_code_1" => "required",           
            "city_1" => "required",           
            "state_1" => "required",           
            "country_1" => "required",  
            "address_2" => "required",                    
            "postal_code_2" => "required",           
            "city_2" => "required",           
            "state_2" => "required",           
            "country_2" => "required",           
            // "phone" => "required|unique:users,phone,".$this->user_id,
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone,". $this->user_id . "",
            // "logo" => "required",
            "ssm_number" => "required",
            "company_name" => "required",
            "company_email" => "required",
            "company_country_code_id"=>"required",
	    // "company_phone" => "required",
            "company_phone" => "required|regex:/^[0-9]+$/|min:8|max:14",
            "product_category" => "required",
            // "product_images" => "required",
            "status" => "required",
        ];
    }
}
