<?php

namespace App\Http\Requests\Order;

use Illuminate\Foundation\Http\FormRequest;

class StoreOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create order');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [ 
            "pickup_address_book_id" => "required",
            "customer_type" => "required|integer",
            "first_name" => "required_if:customer_type,==,1",
            "last_name" => "required_if:customer_type,==,1",
            "email" => "required_if:customer_type,==,1|email|unique:users,email",
            "address" => "required_if:customer_type,==,1",
            "city" => "required_if:customer_type,==,1",
            "postal_code" => "required_if:customer_type,==,1",
            "state" => "required_if:customer_type,==,1",
            "country" => "required_if:customer_type,==,1",
            "country_code_id" => "required_if:customer_type,==,1",
            "phone" => "required_if:customer_type,==,1|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone",
            "company_name" => "required_if:customer_type,==,1",
            "customer_id" => "required_if:customer_type,==,2",
            "order_type" => "required",
            "express_image" => "required_if:order_type,==,2",
            "package_id" => "required",
            "quantity" => "required",
            "price" => "required",           
            "pickup_date" => "required",
            "pickup_time_id" => "required",
            "remarks" => "required"            
        ];

        if (auth()->user()->role === 'SUPER_ADMIN') {
            $rules['merchant_id'] = 'required';
        }
    
        return $rules;
    }
}
