<?php

namespace App\Http\Requests\SalesPerson;

use Illuminate\Foundation\Http\FormRequest;

class StoreSalesPersonRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create sales person');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        $rules = [
            "first_name" => "required",           
            "last_name" => "required",           
            "email" => "required|email|unique:users,email",
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone",
            "country_code_id" => "required",
            "password" => "required",
        ];
    
        if (auth()->user()->role === 'SUPER_ADMIN') {
            $rules['merchant_id'] = 'required';
        }
    
        return $rules;
    }
}
