<?php

namespace App\Listeners;

use App\Events\TopupHistory;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class storeTopupHistory
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Models\TopupHistory  $event
     * @return void
     */
    public function handle(TopupHistory $event)
    {
        $current_timestamp = Carbon::now()->toDateTimeString();

        $topupInfo = $event->topupHistory;
        // dd( $topupInfo['topup_id']);
        $saveHistory = DB::table('topup_histories')->insert(
            [
                'topup_id'=> $topupInfo['topup_id'], 
                'merchant_id'=> $topupInfo['merchant_id'],                 
                'no_of_credits'=> $topupInfo['no_of_credits'],                 
                'receipt'=> $topupInfo['receipt'],                 
                'created_by'=> $topupInfo['created_by'],                 
                'user_agent' => $topupInfo['user_agent'], 
                'login_ip' =>$topupInfo['login_ip'],
                'created_at' => $current_timestamp,
                'updated_at' => $current_timestamp
            ]
        );
        return $saveHistory;
    }
}
