<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('room_categories', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('room_category_name');
            $table->string('room_category_name_ar');
            $table->string('room_category_code');
            $table->string('room_category_desc');
            $table->text('room_category_desc_ar');
            $table->integer('status')->default(0); 
            $table->tinyInteger('is_deleted')->default(0);
            $table->dateTime('deleted_at')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('room_categories');
    }
};
