<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('room_facilities', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('room_facility_name');
            $table->string('room_facility_name_ar');
            $table->string('room_facility_code');
            $table->integer('room_section_type')->default(0);
            $table->text('room_facility_desc');
            $table->text('room_facility_desc_ar');
            $table->integer('status')->default(0); 
            $table->tinyInteger('is_deleted')->default(0);
            $table->dateTime('deleted_at')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('room_facilities');
    }
};
