<form class="form-horizontal" id="image_name_edit_form" autocomplete="off" role="form" method="POST" action="#">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group row @error('image_name') has-error @enderror">
                <label for="image_name" class="control-label col-sm-4"> {{ __('Image Name') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" name="image_name" id="image_name" value="{{ $imageNameInfo->image_name }}" placeholder="Image Name" required maxlength="30">
                    @if($errors->has('image_name'))
                        <p class="text-danger">{{ $errors->first('image_name') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('status') has-error @enderror">
                <label for="status" class="control-label col-sm-4"> {{ __('Status') }} <span class="text-danger">*</span></label>
                <div class="col-sm-8">
                    {!! Form::select('status', $status, $imageNameInfo->status, ['id' => 'status', 'class' => 'form-control m-bot15']) !!}
                    @if($errors->has('status'))
                        <p class="text-danger">{{ $errors->first('status') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row">
        <div class="col-sm-8 offset-sm-4">
        <input type="hidden" name="image_name_id" id="image_name_id" value="{{ $imageNameInfo->id }}" />
            <button type="button" id="editImageNameBtn" class="btn btn-primary" onclick="return editImageName();">{{ __('Update Image Name') }}</button>
            <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
        </div>
    </div>
</form>
