@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Image Name') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Image Name') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Image Name') }}</h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Image Name') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="image_name_table">
                        <thead>
                            <tr>
                                <th>{{ __('Image Name') }}</th>
                                <th>{{ __('Status') }}</th> 
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#image_name_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('image-name.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'image_name', name: 'image_name'},            
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deleteimagename').on('click',function(){
              var x = confirm("Do you want to delete the Image Name?");
              if(x == true) { 
              var imagenameid = $(this).data('image-name'); 
                  $.ajax({
                        url: "{{ route('delete-image-name') }}",
                        data: { "id": imagenameid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                //window.location.reload();
                                toastr.success(data.message, 'Success');
                                $('#image_name_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "{{ route('image-name.ajax-add') }}",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Add Image Name' );
            $('#modal_footer' ).html('');
        }
    });
}
function addImageName()
{
  var image_name = $('#image_name_add_form #image_name').val();
    var status = $('#image_name_add_form #status').val();
    $.ajax({
        url: "{{ route('image-name.addImageName') }}",
        data: { "status": status,"image_name": image_name},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addImageNameBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addImageNameBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#image_name_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#image_name_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        }
    });
}
function ajaxEdit(image_name_id){
    $.ajax({
        url: "{{ route('image-name.ajax-edit') }}",
        data: {"image_name_id": image_name_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Edit Image Name' );
            $('#modal_footer' ).html('');
        }
    });
}
function editImageName()
{
  var image_name = $('#image_name_edit_form #image_name').val();
    var status = $('#image_name_edit_form #status').val();
    var image_name_id = $('#image_name_edit_form #image_name_id').val(); 
    $.ajax({
        url: "{{ route('image-name.editImageName') }}",
        data: { "status": status, "image_name": image_name, "image_name_id": image_name_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editImageNameBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editImageNameBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#image_name_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        }
    });
}
</script>
@endsection