
<?php $__env->startSection('styles'); ?>
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1><?php echo e(__('Contact Type')); ?></h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#"><?php echo e(__('Home')); ?></a></li>
          <li class="breadcrumb-item active"><?php echo e(__('Contact Type')); ?></li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title"><?php echo e(__('Manage Contact Type')); ?></h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> <?php echo e(__('Add New Contact Type')); ?>

                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="contact_type_table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Type Name')); ?></th>
                                <th><?php echo e(__('Type Code')); ?></th> 
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<!-- DataTables  & Plugins -->
<script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#contact_type_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "<?php echo e(route('contact-type.index')); ?>",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'contact_type_name', name: 'contact_type_name'},            
            {data: 'contact_type_code', name: 'contact_type_code'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletecontacttype').on('click',function(){
              var x = confirm("Do you want to delete the Contact Type?");
              if(x == true) { 
              var productcategoryid = $(this).data('contact-type'); 
                  $.ajax({
                      url: "<?php echo e(route('delete-contact-type')); ?>",
                      data: { "id": productcategoryid },
                      type: "post",
                      dataType: "json",
                      success: function (data) {
                        if(data.status == 'success'){
                            toastr.success(data.message, 'Success');
                            $('#contact_type_table').DataTable().ajax.reload();
                        }else{
                            toastr.error('Some problem found. Please try again.','Error');
                        }
                      }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "<?php echo e(route('contact-type.ajax-add')); ?>",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Add Contact Type' );
            $('#modal_footer' ).html('');
        }
    });
}
function addContactType()
{
    var contact_type_name = $('#contact_type_add_form #contact_type_name').val();
    var contact_type_name_ar = $('#contact_type_add_form #contact_type_name_ar').val();
    var contact_type_code = $('#contact_type_add_form #contact_type_code').val();
    var status = $('#contact_type_add_form #status').val();
    $.ajax({
        url: "<?php echo e(route('contact-type.addContactType')); ?>",
        data: { "status": status,"contact_type_name": contact_type_name, "contact_type_name_ar": contact_type_name_ar,"contact_type_code": contact_type_code},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addContactTypeBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addContactTypeBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#contact_type_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#contact_type_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
function ajaxEdit(contact_type_id){
    $.ajax({
        url: "<?php echo e(route('contact-type.ajax-edit')); ?>",
        data: {"contact_type_id": contact_type_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#myModal' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_body' ).html(html);
            $('#modal_title' ).html( 'Edit Contact Type' );
            $('#modal_footer' ).html('');
        }
    });
}
function editContactType()
{
    var contact_type_name = $('#contact_type_edit_form #contact_type_name').val();
    var contact_type_name_ar = $('#contact_type_edit_form #contact_type_name_ar').val();
    var contact_type_code = $('#contact_type_edit_form #contact_type_code').val();
    var status = $('#contact_type_edit_form #status').val();
    var contact_type_id = $('#contact_type_edit_form #contact_type_id').val(); 
    $.ajax({
        url: "<?php echo e(route('contact-type.editContactType')); ?>",
        data: { "status": status, "contact_type_name": contact_type_name, "contact_type_name_ar": contact_type_name_ar, "contact_type_code": contact_type_code, "contact_type_id": contact_type_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editContactTypeBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editContactTypeBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#contact_type_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout-admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\extranet\resources\views/pages/admin/contact-type/list.blade.php ENDPATH**/ ?>