
<?php $__env->startSection('styles'); ?>
  <!-- DataTables -->
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1><?php echo e(__('Hotel Category')); ?></h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#"><?php echo e(__('Home')); ?></a></li>
          <li class="breadcrumb-item active"><?php echo e(__('Hotel Category')); ?></li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title"><?php echo e(__('Manage Hotel Category')); ?></h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> <?php echo e(__('Add New Hotel Category')); ?>

                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="hotel_category_table">
                        <thead>
                            <tr>
                                <th><?php echo e(__('Hotel Category Name')); ?></th>
                                <th><?php echo e(__('Hotel Category Code')); ?></th> 
                                <th><?php echo e(__('Description')); ?></th> 
                                <th><?php echo e(__('Status')); ?></th> 
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<!-- DataTables  & Plugins -->
<script src="<?php echo e(asset('plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/jszip/jszip.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#hotel_category_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "<?php echo e(route('hotel-category.index')); ?>",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'hotel_category_name', name: 'hotel_category_name'},
            {data: 'hotel_category_code', name: 'hotel_category_code'}, 
            {data: 'hotel_category_desc', name: 'hotel_category_desc'},           
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deletehotelcategory').on('click',function(){
              var x = confirm("Do you want to delete the Hotel Category?");
              if(x == true) { 
              var imagenameid = $(this).data('hotel-category'); 
                  $.ajax({
                        url: "<?php echo e(route('delete-hotel-category')); ?>",
                        data: { "id": imagenameid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                //window.location.reload();
                                toastr.success(data.message, 'Success');
                                $('#hotel_category_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "<?php echo e(route('hotel-category.ajax-add')); ?>",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            // alert(html)
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Add Hotel Category' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function addHotelCategory()
{
    var hotel_category_name = $('#hotel_category_add_form #hotel_category_name').val();
    var hotel_category_name_ar = $('#hotel_category_add_form #hotel_category_name_ar').val();
    var hotel_category_code = $('#hotel_category_add_form #hotel_category_code').val();
    var hotel_category_desc = $('#hotel_category_add_form #hotel_category_desc').val();
    var hotel_category_desc_ar = $('#hotel_category_add_form #hotel_category_desc_ar').val();
    var status = $('#hotel_category_add_form #status').val();
    $.ajax({
        url: "<?php echo e(route('hotel-category.addHotelCategory')); ?>",
        data: { "hotel_category_name": hotel_category_name, "hotel_category_name_ar": hotel_category_name_ar,"hotel_category_code": hotel_category_code,"hotel_category_desc": hotel_category_desc, "hotel_category_desc_ar": hotel_category_desc_ar, "status": status},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#addHotelCategoryBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#addHotelCategoryBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                $('#hotel_category_add_form')[0].reset();
                toastr.success(res.message, 'Success');
                $('#hotel_category_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
function ajaxEdit(hotel_category_id){
    $.ajax({
        url: "<?php echo e(route('hotel-category.ajax-edit')); ?>",
        data: {"hotel_category_id": hotel_category_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Edit Hotel Category' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function editHotelCategory()
{
    var hotel_category_name = $('#hotel_category_edit_form #hotel_category_name').val();
    var hotel_category_name_ar = $('#hotel_category_edit_form #hotel_category_name_ar').val();
    var hotel_category_code = $('#hotel_category_edit_form #hotel_category_code').val();
    var hotel_category_desc = $('#hotel_category_edit_form #hotel_category_desc').val();
    var hotel_category_desc_ar = $('#hotel_category_edit_form #hotel_category_desc_ar').val();
    var status = $('#hotel_category_edit_form #status').val();
    var hotel_category_id = $('#hotel_category_edit_form #hotel_category_id').val(); 
    $.ajax({
        url: "<?php echo e(route('hotel-category.editHotelCategory')); ?>",
        data: { "hotel_category_name": hotel_category_name, "hotel_category_name_ar": hotel_category_name_ar,"hotel_category_code": hotel_category_code,"hotel_category_desc": hotel_category_desc, "hotel_category_desc_ar": hotel_category_desc_ar, "status": status, "hotel_category_id": hotel_category_id},
        type: "post",
        dataType: "json",
        beforeSend: function() { 
            $("#editHotelCategoryBtn").prop('disabled', true);
        },
        success: function (res) {
            $("#editHotelCategoryBtn").prop('disabled', false);
            if(res.status == 'failed'){
                if(res.error){
                    $.each(res.error, function(i, item) {
                        toastr.error(item[0],'Error');
                    });
                }else{
                    toastr.error('Some problem found. Please try again.','Error');
                }
            }else{
                toastr.success(res.message, 'Success');
                $('#hotel_category_table').DataTable().ajax.reload();
                $("#myModal").modal("hide");
            }
        },
        error: function(xhr, resp, text) {
            console.log(xhr, resp, text);
        }
    });
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout-admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\extranet\resources\views/pages/admin/hotel-category/list.blade.php ENDPATH**/ ?>