<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use App\Models\Hub;
use App\Models\Merchant;
use App\Models\Order;
use App\Models\SalesPerson;
use Illuminate\Http\Request;
use Auth;

class DashboardController extends Controller
{
    public function index()
    {
        // dd(
        //     app('auth')->user()->getAllPermissions()->toArray(),
        //     app('auth')->user()->can('manage vehicle type'),
        //     app('auth')->user()->hasPermissionTo('manage vehicle type')
        // );
        if(\Auth::user()->role == "SUPERADMIN")
        {
            $data['total_hub'] = array();
            return view('pages.admin.dashboard.list',$data);
        }
        else if(\Auth::user()->role == "MERCHANT")
        {
            $data['total_order'] = Order::where('created_by',Auth::user()->id)->count();
            $data['total_customer'] = Customer::where('created_by',Auth::user()->id)->count();
            $data['total_sales_person'] = SalesPerson::where('created_by',Auth::user()->id)->count();
            return view('pages.admin.merchant-dashboard.list',$data);
        }
        else if(\Auth::user()->role == "SALES_PERSON")
        {
            $data['total_order'] = Order::where('created_by',Auth::user()->id)->count();
            $data['total_customer'] = Customer::where('created_by',Auth::user()->id)->count();
            return view('pages.admin.sales-person.dashboard',$data);
        }
        else
        {
            return "un authenticated";
        }
    }

    
}
