<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Location;
use DataTables;
use Validator;

class LocationController extends Controller
{
    public function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = Location::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("country_name", function ($data) {
                    if (empty($data->country_name)) {
                        return "N/A";
                    }
                    return $data->country_name;
                })
                ->addColumn("city_name", function ($data) {
                    if (empty($data->city_name)) {
                        return "N/A";
                    }
                    return $data->city_name;
                })
                ->addColumn("zone_code", function ($data) {
                    if (empty($data->zone_code)) {
                        return "N/A";
                    }
                    return $data->zone_code;
                })
                ->addColumn("zone_name", function ($data) {
                    if (empty($data->zone_name)) {
                        return "N/A";
                    }
                    return $data->zone_name;
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-info">Action</button>
                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletelocation" href="javascript:;" data-location="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Location";
        return view("pages.admin.location.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $location = Location::find($request->id);
        $location->is_deleted = 1;
        $location->deleted_at = date('Y-m-d H:i:s');
        $location->save();
        //$location->delete();
        return response()->json(['status' => 'success', 'message' => 'Location information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data = array();
        return view('pages.admin.location.ajaxAdd',$data);
    }
    public function addLocation(Request $request)
    {
        $messages = array(
                        'country_name.required' => 'Country Name is Required',
                        'country_name_ar.required' => 'Country Name(AR) is Required',
                        'city_name.required' => 'City Name is Required',
                        'city_name_ar.required' => 'City Name(AR) is Required',
                    );
        $validator = Validator::make($request->all(), [
                                                'country_name' => 'required',
                                                'country_name_ar' => 'required',
                                                'city_name' => 'required',
                                                'city_name_ar' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $location = Location::create([  
                "country_name" => trim($request->country_name),
                "country_name_ar" => trim($request->room_facility_name_ar),
                "city_name" => trim($request->city_name),
                "city_name_ar" => trim($request->city_name_ar),
                "zone_code" => trim($request->zone_code),
                "zone_code_ar" => trim($request->zone_code_ar),
                "zone_name" => trim($request->zone_name),
                "zone_name_ar" => trim($request->zone_name_ar)
            ]);
            return response()->json(['status' => 'success', 'message' => 'Location added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $locationInfo = Location::find($request->location_id);
        $data["locationInfo"] = $locationInfo;
        return view('pages.admin.location.ajaxEdit',$data);
    }
    public function editLocation(Request $request)
    {
        $messages = array(
                        'country_name.required' => 'Country Name is Required',
                        'country_name_ar.required' => 'Country Name(AR) is Required',
                        'city_name.required' => 'City Name is Required',
                        'city_name_ar.required' => 'City Name(AR) is Required',
        );
        $validator = Validator::make($request->all(), [
                                            'country_name' => 'required',
                                            'country_name_ar' => 'required',
                                            'city_name' => 'required',
                                            'city_name_ar' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $location = Location::find($request->location_id);
            $location->country_name = trim($request->country_name);
            $location->country_name_ar = trim($request->country_name_ar);
            $location->city_name = trim($request->city_name);
            $location->city_name_ar = trim($request->city_name_ar);
            $location->zone_code = trim($request->zone_code);
            $location->zone_code_ar = trim($request->zone_code_ar);
            $location->zone_name = trim($request->zone_name);
            $location->zone_name_ar = trim($request->zone_name_ar);
            $location->save();

            return response()->json(['status' => 'success', 'message' => 'Location updated successfully.', 'error' => ''], 200);
        }
    }
}
