<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\MealPlan;
use DataTables;
use Validator;

class MealPlanController extends Controller
{
    public function __construct()
    {
        $this->mealPlanStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = MealPlan::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("meal_plan_name", function ($data) {
                    if (empty($data->meal_plan_name)) {
                        return "N/A";
                    }
                    return $data->meal_plan_name;
                })
                ->addColumn("meal_plan_code", function ($data) {
                    if (empty($data->meal_plan_code)) {
                        return "N/A";
                    }
                    return $data->meal_plan_code;
                })
                ->addColumn("meal_plan_desc", function ($data) {
                    if (empty($data->meal_plan_desc)) {
                        return "N/A";
                    }
                    return $data->meal_plan_desc;
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-sm btn-info">Action</button>
                        <button type="button" class="btn btn-sm btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletemealplan" href="javascript:;" data-meal-plan="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Meal Plan";
        return view("pages.admin.meal-plan.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $mealPlan = MealPlan::find($request->id);
        $mealPlan->is_deleted = 1;
        $mealPlan->deleted_at = date('Y-m-d H:i:s');
        $mealPlan->save();
        //$mealPlan->delete();
        return response()->json(['status' => 'success', 'message' => 'Meal Plan information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->mealPlanStatus;
        return view('pages.admin.meal-plan.ajaxAdd',$data);
    }
    public function addMealPlan(Request $request)
    {
        $messages = array(
                    'meal_plan_name.required' => 'Meal Plan Name is Required',
                    'meal_plan_name_ar.required' => 'Meal Plan Name(AR) is Required',
                    'meal_plan_code.required' => 'Meal Plan Code is Required',
                );
        $validator = Validator::make($request->all(), [
                                        'meal_plan_name' => 'required',
                                        'meal_plan_name_ar' => 'required',
                                        'meal_plan_code' => 'required',
                                    ], $messages);
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $mealPlan = MealPlan::create([            
                "meal_plan_name" => trim($request->meal_plan_name),
                "meal_plan_name_ar" => trim($request->meal_plan_name_ar),
                "meal_plan_code" => trim($request->meal_plan_code),
                "meal_plan_desc" => trim($request->meal_plan_desc),
                "meal_plan_desc_ar" => trim($request->meal_plan_desc_ar),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Meal Plan added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $mealPlanInfo = MealPlan::find($request->meal_plan_id);
        $data["mealPlanInfo"] = $mealPlanInfo;
        $data["status"] = $this->mealPlanStatus;
        return view('pages.admin.meal-plan.ajaxEdit',$data);
    }
    public function editMealPlan(Request $request)
    {
        $messages = array(
                        'meal_plan_name.required' => 'Meal Plan Name is Required',
                        'meal_plan_name_ar.required' => 'Meal Plan Name(AR) is Required',
                        'meal_plan_code.required' => 'Meal Plan Code is Required',
                    );
        $validator = Validator::make($request->all(), [
                                            'meal_plan_name' => 'required',
                                            'meal_plan_name_ar' => 'required',
                                            'meal_plan_code' => 'required',
                                        ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $mealPlan = MealPlan::find($request->meal_plan_id);
            $mealPlan->meal_plan_name = $request->meal_plan_name;
            $mealPlan->meal_plan_name_ar = $request->meal_plan_name_ar;
            $mealPlan->meal_plan_code = $request->meal_plan_code;
            $mealPlan->meal_plan_desc = $request->meal_plan_desc;
            $mealPlan->meal_plan_desc_ar = $request->meal_plan_desc_ar;
            $mealPlan->status = $request->status;
            $mealPlan->save();

            return response()->json(['status' => 'success', 'message' => 'Meal Plan updated successfully.', 'error' => ''], 200);
        }
    }
}
