<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\RoomFacility;
use DataTables;
use Validator;

class RoomFacilityController extends Controller
{
    public function __construct()
    {
        $this->roomFacilityStatus = ["1" => "Active", "2" => "Inactive"];
        $this->roomSectionType = ["1" => "Sec 1", "2" => "Sec 2"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = RoomFacility::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("room_facility_name", function ($data) {
                    if (empty($data->room_facility_name)) {
                        return "N/A";
                    }
                    return $data->room_facility_name;
                })
                ->addColumn("room_facility_code", function ($data) {
                    if (empty($data->room_facility_code)) {
                        return "N/A";
                    }
                    return $data->room_facility_code;
                })
                ->addColumn("room_section_type", function ($data) {
                    if (empty($data->room_section_type)) {
                        return "N/A";
                    }
                    return $this->roomSectionType[$data->room_section_type];
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-info">Action</button>
                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deleteroomfacility" href="javascript:;" data-room-facility="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Room Facility";
        return view("pages.admin.room-facility.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $roomFacility = RoomFacility::find($request->id);
        $roomFacility->is_deleted = 1;
        $roomFacility->deleted_at = date('Y-m-d H:i:s');
        $roomFacility->save();
        //$roomFacility->delete();
        return response()->json(['status' => 'success', 'message' => 'Room Facility information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->roomFacilityStatus;
        $data["sectionType"] = $this->roomSectionType;
        return view('pages.admin.room-facility.ajaxAdd',$data);
    }
    public function addRoomFacility(Request $request)
    {
        $messages = array(
                        'room_facility_name.required' => 'Room Facility Name is Required',
                        'room_facility_name_ar.required' => 'Room Facility Name(AR) is Required',
                        'room_facility_code.required' => 'Room Facility Code is Required',
                    );
        $validator = Validator::make($request->all(), [
                                                'room_facility_name' => 'required',
                                                'room_facility_name_ar' => 'required',
                                                'room_facility_code' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $ImageName = RoomFacility::create([  
                "room_facility_name" => trim($request->room_facility_name),
                "room_facility_name_ar" => trim($request->room_facility_name_ar),
                "room_facility_code" => trim($request->room_facility_code),
                "room_section_type" => trim($request->room_section_type),
                "room_facility_desc" => trim($request->room_facility_desc),
                "room_facility_desc_ar" => trim($request->room_facility_desc_ar),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Room Facility added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $roomFacilityInfo = RoomFacility::find($request->room_facility_id);
        $data["roomFacilityInfo"] = $roomFacilityInfo;
        $data["status"] = $this->roomFacilityStatus;
        $data["sectionType"] = $this->roomSectionType;
        return view('pages.admin.room-facility.ajaxEdit',$data);
    }
    public function editRoomFacility(Request $request)
    {
        $messages = array(
            'room_facility_name.required' => 'Room Facility Name is Required',
            'room_facility_name_ar.required' => 'Room Facility Name(AR) is Required',
            'room_facility_code.required' => 'Room Facility Code is Required',
        );
        $validator = Validator::make($request->all(), [
                                                'room_facility_name' => 'required',
                                                'room_facility_name_ar' => 'required',
                                                'room_facility_code' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $roomFacility = RoomFacility::find($request->room_facility_id);
            $roomFacility->room_facility_name = $request->room_facility_name;
            $roomFacility->room_facility_name_ar = $request->room_facility_name_ar;
            $roomFacility->room_facility_code = $request->room_facility_code;
            $roomFacility->room_section_type = $request->room_section_type;
            $roomFacility->room_facility_desc = $request->room_facility_desc;
            $roomFacility->room_facility_desc_ar = $request->room_facility_desc_ar;
            $roomFacility->status = $request->status;
            $roomFacility->save();

            return response()->json(['status' => 'success', 'message' => 'Room Facility updated successfully.', 'error' => ''], 200);
        }
    }
}
