<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Setting\updateSettingRequest;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Unit;

use Auth;
use DataTables;
use Illuminate\Database\QueryException;

class SettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(\Auth::user()->can('list setting'))
        {
            if ($request->ajax()) 
            {

                $results = Setting::isNotDeleted()->get();
                    
                
                return DataTables::of($results)
                    ->addIndexColumn()
                    ->addColumn("setting_name", function ($data) {
                        if (empty($data->setting_name)) {
                            return "N/A";
                        }
                        return $data->setting_name;
                    })
                
                    ->addColumn("setting_value", function ($data) {
                        if (empty($data->setting_value)) {
                            return "N/A";
                        }
                        return $data->setting_value;
                    })
                    ->addColumn("action", function ($data) {
                        
                        $btn =
                            '<a class="btn btn-info btn-xs" href="' .
                            route("setting.edit", $data->setting_id) .
                            '" data-toggle="tooltip" data-placement="top" title="Edit Setting"><i class="fa fa-edit"></i> Edit</a>&nbsp;';
                        // $btn .=
                        //     '<a class="btn btn-danger btn-xs deletesetting" href="javascript:;" data-setting="' .
                        //     $data->setting_id .
                        //     '" data-toggle="tooltip" data-placement="top" title="Delete Setting"><i class="fa fa-trash"></i> Delete</a>';
                        return $btn;
                    })
                    ->rawColumns(["action"])
                    ->make(true);                    
            }
            $data["title"] = "Manage Setting";
            $data["settings"]=Setting::with('unit')->get();

            return view("pages.admin.setting.list", $data);
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }

        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if(\Auth::user()->can('edit setting'))
        {
            $settingInfo = Setting::find($id);
            $data["settingInfo"] = $settingInfo;
            return view('pages.admin.setting.edit',$data);
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    public function ajaxEdit(Request $request)
    {
        if(\Auth::user()->can('edit setting'))
        {
            $data["settingInfo"] = Setting::find($request->setting_id);
            $data["units"] = Unit::get();

            return view('pages.admin.setting.ajaxEdit',$data);

            // return $data;
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(updateSettingRequest $request, $id)
    {
        if(\Auth::user()->can('edit setting'))
        {            
            try
            {            
                $setting = Setting::find($id);
                $setting->display_name =  $request->display_name;  
                $setting->setting_value =  $request->setting_value;  
                $setting->unit_id=$request->unit_id;
                $setting->created_by = \Auth::user()->id;           
                $setting->save();  
            }
            catch(QueryException $ex) 
            {
                return redirect()
                    ->route("setting.index")
                    ->with("failed", "Update Error");
            }
            return redirect()
                ->route("setting.index")
                ->with("success", "Setting updated successfully!");   
        }
        else
        {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $setting = Setting::find($request->id);
        $setting->is_deleted = 1;
        $setting->deleted_at = date('Y-m-d H:i:s');
        $setting->save();

        Session::flash("success", "Setting information deleted successfully.");
        return 1;
    }

    public function updateAdminSetting(Request $request)
    {
        if(\Auth::user()->can('manage setting'))
        {
            $user_id = \Auth::user()->id;
            $request->validate(
                [
                    'admin_contact_number' => 'required|string|max:255',
                    'est_time_limit' => 'required|string|max:255',
                ]
            );
            $post = $request->all();
            unset($post['_token']);

            foreach($post as $key => $data)
            {
                \DB::insert(
                    'insert into settings (`value`, `name`,`created_by`) values (?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ', [
                                                                                                                                                 $data,
                                                                                                                                                 $key,
                                                                                                                                                 Auth::user()->id,
                                                                                                                                             ]
                );
            }

            return redirect()->back()->with('success', __('Setting successfully updated.'));
        }
        else
        {
            return redirect()->back()->with('error', 'Permission denied.');
        }
    }
}
