<?php

namespace App\Http\Requests\Customer;

use Illuminate\Foundation\Http\FormRequest;

class StoreCustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->user()->can('create customer');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            "first_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "last_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "email" => "required|email|unique:users,email",
            "address" =>"required|max:100",
            "city" => "required|regex:/^[a-zA-Z0 ]*$/",
            "postal_code" => "required|regex:/^[0-9]+$/|max:5",
            "state" => "required|regex:/^[a-zA-Z0 ]*$/",
            "country" => "required|regex:/^[a-zA-Z0 ]*$/",
            "country_code_id" => "required",
            // "phone" => "required|regex:/^[0-9]+$/|max:30|unique:users,phone",
            "phone" => "required|regex:/^[0-9]+$/|min:8|max:14|unique:users,phone",
            "company_name" =>"required|regex:/^[a-zA-Z&0 ]*$/",
            "status" => "required",
        ];
    
        if (auth()->user()->role === 'SUPER_ADMIN') {
            $rules['merchant_id'] = 'required';
        }
    
        return $rules;
    }
}
