<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Utility extends Model
{
    use HasFactory;

    public static function settings()
    {
        $data = DB::table('settings');   
        
        $data     = $data->get();
        
        foreach($data as $row)
        {
            $settings[$row->name] = $row->value;
        }

        return $settings;
    }
    public static function getLogo()
    {
        if(\Auth::user()->role == 'MERCHANT')
        {
            
            if(isset(\Auth::user()->merchant->logo))
            {
                $merchant_logo = \Auth::user()->merchant->logo;
                $logo = base_path()."/public/uploads/merchant_logos/" .$merchant_logo; 
                if(file_exists($logo))
                {
                    $logo = "uploads/merchant_logos/".$merchant_logo;
                }
                else
                {
                    $logo = 'dist/img/SuhuLogo.png';
                }
            }
            else
            {
                $logo = 'dist/img/SuhuLogo.png';
            }
            
        }
        else
        {
            $logo = 'dist/img/SuhuLogo.png';
        }        
        return $logo;
    }
    public static function getValidPhone($country_code_id,$phone)
    {
        if($country_code_id == 132)//for malaysia
        {
            if (substr($phone, 0, 2) == "60")
                return substr($phone, 2, strlen($phone)); 
            elseif (substr($phone, 0, 3) == "+60")
                return substr($phone, 3, strlen($phone));
            elseif (substr($phone, 0, 1) == "0")
                return substr($phone, 1, strlen($phone)); 
            elseif (substr($phone, 0, 2) == "+0")
                return substr($phone, 2, strlen($phone)); 
            else
                return  $phone;
        }
        else
        {
            if (substr($phone, 0, 1) == "0")
                return substr($phone, 1, strlen($phone)); 
            elseif (substr($phone, 0, 2) == "+0")
                return substr($phone, 2, strlen($phone)); 
            else
                return  $phone;
        }
    }

}
