@extends('layouts.layout-admin')
@section('styles')
  <!-- DataTables -->
  <link rel="stylesheet" href="{{ asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
  <link rel="stylesheet" href="{{ asset('plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
  <style>
    .dataTables_filter {
      margin-left: 10px;
      float: right;
    }
    .dataTables_info{
      float:left;
    }

  </style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Room Facility') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Room Facility') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Room Facility') }}</h3>
                  <a href="javascript:;" onclick="ajaxAdd();" style="float:right;" data-toggle="tooltip" title="Add" class="btn btn-primary btn-sm" data-toggle="tooltip" data-original-title="Add New">
                    <i class="fa fa-plus"></i> {{ __('Add New Room Facility') }}
                </a>
                </div>
                <!-- /.card-header -->
              <div class="card-body"> 
                                
                    <table class="table table-bordered table-striped" id="room_facility_table">
                        <thead>
                            <tr>
                                <th>{{ __('Facility Name') }}</th>
                                <th>{{ __('Facility Code') }}</th> 
                                <th>{{ __('Setion Type') }}</th> 
                                <th>{{ __('Status') }}</th> 
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')

<!-- DataTables  & Plugins -->
<script src="{{ asset('plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('plugins/jszip/jszip.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script type="text/javascript">
$(document).ready(function(){
    $.ajaxSetup({
          headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
    });

    var table = $('#room_facility_table').DataTable({
        processing: true,
        serverSide: true,        
        ajax: {
          url: "{{ route('room-facility.index') }}",
          type: 'GET',
          data: function (d) {
            d.name = '';
          }
        },
        columns: [
            {data: 'room_facility_name', name: 'room_facility_name'},
            {data: 'room_facility_code', name: 'room_facility_code'}, 
            {data: 'room_section_type', name: 'room_section_type'},           
            {data: 'status', name: 'status'},
            {data: 'action', name: 'action', orderable: false},
        ],
        order: [[0, 'asc']],
        responsive:true,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',        
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {
          $('[data-toggle="tooltip"]').tooltip(); // for tooltips in controls
          $('.deleteroomfacility').on('click',function(){
              var x = confirm("Do you want to delete the Room Facility?");
              if(x == true) { 
              var imagenameid = $(this).data('room-facility'); 
                  $.ajax({
                        url: "{{ route('delete-room-facility') }}",
                        data: { "id": imagenameid },
                        type: "post",
                        dataType: "json",
                        success: function (data) {
                            if(data.status == 'success'){
                                toastr.success(data.message, 'Success');
                                $('#room_facility_table').DataTable().ajax.reload();
                            }else{
                                toastr.error('Some problem found. Please try again.','Error');
                            }
                        }
                  });
              }
            });
          }        
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');    
});

function ajaxAdd(){
    $.ajax({
        url: "{{ route('room-facility.ajax-add') }}",
        data: {},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Add Room Facility' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function addRoomFacility()
{
    var room_facility_name = $('#room_facility_add_form #room_facility_name').val();
    var room_facility_name_ar = $('#room_facility_add_form #room_facility_name_ar').val();
    var room_facility_code = $('#room_facility_add_form #room_facility_code').val();
    var room_section_type = $('#room_facility_add_form #room_section_type').val();
    var room_facility_desc = $('#room_facility_add_form #room_facility_desc').val();
    var room_facility_desc_ar = $('#room_facility_add_form #room_facility_desc_ar').val();
    var status = $('#room_facility_add_form #status').val();
    var isValid = 1;
    if (room_facility_name == "") {
        toastr.error('Please enter room facility name','Error');
        isValid = 0;
    }
    if (room_facility_name_ar == "") {
        toastr.error('Please enter room facility name(AR)','Error');
        isValid = 0;
    }
    if (room_facility_code == "") {
        toastr.error('Please enter room facility code','Error');
        isValid = 0;
    }
    if(isValid){
        $.ajax({
            url: "{{ route('room-facility.addRoomFacility') }}",
            data: { "room_facility_name": room_facility_name, "room_facility_name_ar": room_facility_name_ar, "room_facility_code": room_facility_code, "room_section_type": room_section_type, "room_facility_desc": room_facility_desc, "room_facility_desc_ar": room_facility_desc_ar, "status": status},
            type: "post",
            dataType: "json",
            beforeSend: function() { 
                $("#addRoomFacilityBtn").prop('disabled', true);
            },
            success: function (res) {
                $("#addRoomFacilityBtn").prop('disabled', false);
                if(res.status == 'failed'){
                    if(res.error){
                        $.each(res.error, function(i, item) {
                            toastr.error(item[0],'Error');
                        });
                    }else{
                        toastr.error('Some problem found. Please try again.','Error');
                    }
                }else{
                    $('#room_facility_add_form')[0].reset();
                    toastr.success(res.message, 'Success');
                    $('#room_facility_table').DataTable().ajax.reload();
                    $("#modal_lg").modal("hide");
                }
            },
            error: function(xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        });
    }
}
function ajaxEdit(room_facility_id){
    $.ajax({
        url: "{{ route('room-facility.ajax-edit') }}",
        data: {"room_facility_id": room_facility_id},
        type: "post",
        dataType: "html",
        cache: false,
        success: function (html) {
            $( '#modal_lg' ).modal({ backdrop: 'static', keyboard: false });
            $( '#modal_lg_body' ).html(html);
            $('#modal_lg_title' ).html( 'Edit Room Facility' );
            $('#modal_lg_footer' ).html('');
        }
    });
}
function editRoomFacility()
{
    var room_facility_name = $('#room_facility_edit_form #room_facility_name').val();
    var room_facility_name_ar = $('#room_facility_edit_form #room_facility_name_ar').val();
    var room_facility_code = $('#room_facility_edit_form #room_facility_code').val();
    var room_section_type = $('#room_facility_edit_form #room_section_type').val();
    var room_facility_desc = $('#room_facility_edit_form #room_facility_desc').val();
    var room_facility_desc_ar = $('#room_facility_edit_form #room_facility_desc_ar').val();
    var status = $('#room_facility_edit_form #status').val();
    var room_facility_id = $('#room_facility_edit_form #room_facility_id').val();
    var isValid = 1;
    if (room_facility_name == "") {
        toastr.error('Please enter room facility name','Error');
        isValid = 0;
    }
    if (room_facility_name_ar == "") {
        toastr.error('Please enter room facility name(AR)','Error');
        isValid = 0;
    }
    if (room_facility_code == "") {
        toastr.error('Please enter room facility code','Error');
        isValid = 0;
    }
    if(isValid){
        $.ajax({
            url: "{{ route('room-facility.editRoomFacility') }}",
            data: { "room_facility_name": room_facility_name, "room_facility_name_ar": room_facility_name_ar, "room_facility_code": room_facility_code, "room_section_type": room_section_type, "room_facility_desc": room_facility_desc, "room_facility_desc_ar": room_facility_desc_ar, "status": status, "room_facility_id": room_facility_id},
            type: "post",
            dataType: "json",
            beforeSend: function() { 
                $("#editRoomFacilityBtn").prop('disabled', true);
            },
            success: function (res) {
                $("#editRoomFacilityBtn").prop('disabled', false);
                if(res.status == 'failed'){
                    if(res.error){
                        $.each(res.error, function(i, item) {
                            toastr.error(item[0],'Error');
                        });
                    }else{
                        toastr.error('Some problem found. Please try again.','Error');
                    }
                }else{
                    toastr.success(res.message, 'Success');
                    $('#room_facility_table').DataTable().ajax.reload();
                    $("#modal_lg").modal("hide");
                }
            },
            error: function(xhr, resp, text) {
                console.log(xhr, resp, text);
            }
        });
    }
}
</script>
@endsection