<form class="form-horizontal" id="setting_edit_form" autocomplete="off" role="form" enctype="multipart/form-data" method="POST" action="{{ route('setting.update', $settingInfo->setting_id ) }}">
    @csrf
    {{method_field('PUT')}}
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group row @error('setting_name') has-error @enderror">
                <label for="setting_name" class="control-label col-sm-4"> {{ __('Setting Name') }} <span class="text-danger">*</span></label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="setting_name" id="setting_name" value="{{ $settingInfo->setting_name }}" placeholder="Setting Name" disabled >
                    @if($errors->has('setting_name'))
                    <p class="text-danger">{{ $errors->first('setting_name') }}</p>
                @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('display_name') has-error @enderror">
                <label for="display_name" class="control-label col-sm-4"> {{ __('Display Name') }} <span class="text-danger">*</span></label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="display_name" id="display_name" value="{{ $settingInfo->display_name }}" placeholder="Display Name" required maxlength="30">
                    @if($errors->has('display_name'))
                        <p class="text-danger">{{ $errors->first('display_name') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('setting_value') has-error @enderror">
                <label for="setting_value" class="control-label col-sm-4"> {{ __('Setting Value') }} <span class="text-danger">*</span></label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="setting_value" id="setting_value" value="{{ $settingInfo->setting_value }}" placeholder="Setting Value" required maxlength="30">
                    @if($errors->has('setting_value'))
                        <p class="text-danger">{{ $errors->first('setting_value') }}</p>
                    @endif
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="form-group row @error('unit_id') has-error @enderror">
                <label for="display_unit_id" class="control-label col-sm-4"> {{ __('Units') }} <span class="text-danger">*</span></label>
                <div class="col-sm-4">
                    <select class="form-control" id="unit_id" name="unit_id" required>

                    <option value="">{{ __('select') }}</option>
                    @foreach($units as $unit)
                        <option value="{{ $unit->unit_id }}" {{ ($unit->unit_id == $settingInfo->unit_id)?'selected':'' }}>{{ $unit->unit_name }}</option>
                    @endforeach
                </select>
                    @if($errors->has('unit_id'))
                        <p class="text-danger">{{ $errors->first('unit_id') }}</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row" style="text-align: center;">
        <div class="col-sm-12">
            <button type="submit" id="settingEditBtn" class="btn btn-primary">{{ __('Update Setting') }}</button>
            <a href="{{ route('setting.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
        </div>
    </div>
</form>
