@extends('layouts.layout-admin')
@section('content')
<!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
            <h1 class="m-0">{{ __('Create Menu') }}</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
                <li class="breadcrumb-item active">{{ __('Create Menu') }}</li>
            </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
  <!-- /.content-header -->
  <section class="content">
    <div class="container-fluid">
    <!-- Main content -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">{{ __('Create Menu') }}</h3>                  
                    <span class="tools" style="float:right">
                      <a href="{{ route('menu.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                    </span>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body">  
                
            <form accept="{{ route('menu.store')}}" method="post">
                @csrf
                 @if(count($errors) > 0)
                          <div class="alert alert-danger  alert-dismissible">
                              <button type="button" class="close" data-dismiss="alert">×</button>
                              @foreach($errors->all() as $error)
                                      {{ $error }}<br>
                              @endforeach
                          </div>
                      @endif
                  @if ($message = Session::get('success'))
                   <div class="alert alert-success  alert-dismissible">
                       <button type="button" class="close" data-dismiss="alert">×</button>   
                           <strong>{{ $message }}</strong>
                   </div>
                @endif
                <div class="row">
                   <div class="col-md-12">
                      <div class="form-group">
                         <label>Title</label>
                         <input type="text" name="menu_name" class="form-control">   
                      </div>
                   </div>
                </div>
                <div class="row">
                   <div class="col-md-12">
                      <div class="form-group">
                         <label>Parent</label>
                         <select class="form-control" name="parent_id">
                            <option selected disabled>Select Parent Menu</option>
                            @foreach($allMenus as $key => $value)
                               <option value="{{ $key }}">{{ $value}}</option>
                            @endforeach
                         </select>
                      </div>
                   </div>
                </div>
                {{-- <div class="row">
                    <div class="col-md-12">
                       <div class="form-group">
                          <label>{{ __('Permission') }}</label>
                          <select class="form-control" name="parent_id">
                             <option selected disabled>{{ __('Select Permission') }}</option>
                             @foreach($permissions as $permission)
                                <option value="{{ $permission->id }}">{{ $permission->name}}</option>
                             @endforeach
                          </select>
                       </div>
                    </div>
                 </div> --}}
                <div class="row">
                   <div class="col-md-12">
                      <button class="btn btn-success">Save</button>
                   </div>
                </div>
             </form>
            </div>
        </div>
    </div>
  </div>
</div>
</section>
@endsection
