@extends('layouts.layout-admin')
@section('styles')
<!-- Select2 -->
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
.control-label{
    text-align: right;
}
.hide{
    display: none;
}
</style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>{{ __('Edit Customer') }}</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
            <li class="breadcrumb-item active">{{ __('Edit Customer') }}</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
                  <div class="card-header">
                    <h3 class="card-title">{{ __('Edit Customer') }}</h3>                  
                    <span class="tools" style="float:right">
                      <a href="{{ route('merchant.customer.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                    </span>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body"> 
                       
                    <form class="form-horizontal" id="customer_edit_form" autocomplete="off" role="form" enctype="multipart/form-data" method="POST" action="{{ route('merchant.customer.update', $customerInfo->id ) }}">
                        @csrf
                        {{method_field('PUT')}}
                        <div class="row">
                          <div class="col-sm-6">
                            <div class="form-group row @error('user_name') has-error @enderror">
                                <label for="user_name" class="col-sm-4 control-label">{{ __('User Name') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="user_name" id="user_name" value="{{ $customerInfo->user_name }}" placeholder="User Name">
                                    @if($errors->has('user_name'))
                                        <p class="text-danger">{{ $errors->first('user_name') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          
                          <div class="col-sm-6">
                            <div class="form-group row @error('email') has-error @enderror">
                                <label for="email" class="col-sm-4 control-label">{{ __('Email') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="email" class="form-control" name="email" id="email" value="{{$customerInfo->email }}" placeholder="Email">
                                    @if($errors->has('email'))
                                        <p class="text-danger">{{ $errors->first('email') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="form-group row @error('address_line_1') has-error @enderror">
                                <label for="address_line_1" class="col-sm-4 control-label">{{ __('Address Line 1') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="address_line_1" id="address_line_1" value="{{ $customerInfo->address_line_1 }}" placeholder="Address Line 1">
                                    @if($errors->has('address_line_1'))
                                        <p class="text-danger">{{ $errors->first('address_line_1') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="form-group row @error('address_line_2') has-error @enderror">
                                <label for="address_line_2" class="col-sm-4 control-label">{{ __('Address Line 2') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="address_line_2" id="address_line_2" value="{{ $customerInfo->address_line_2 }}" placeholder="Address Line 2">
                                    @if($errors->has('address_line_2'))
                                        <p class="text-danger">{{ $errors->first('address_line_2') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="form-group row @error('city') has-error @enderror">
                                <label for="city" class="col-sm-4 control-label">{{ __('City') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="city" id="city" value="{{ $customerInfo->city }}" placeholder="City">
                                    @if($errors->has('city'))
                                        <p class="text-danger">{{ $errors->first('city') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="form-group row @error('postal_code') has-error @enderror">
                                <label for="postal_code" class="col-sm-4 control-label">{{ __('Postal Code') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="postal_code" id="postal_code" value="{{ $customerInfo->postal_code }}" placeholder="Postal Code">
                                    @if($errors->has('postal_code'))
                                        <p class="text-danger">{{ $errors->first('postal_code') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="form-group row @error('state') has-error @enderror">
                                <label for="state" class="col-sm-4 control-label">{{ __('State') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="state" id="state" value="{{ $customerInfo->state }}" placeholder="State">
                                    @if($errors->has('state'))
                                        <p class="text-danger">{{ $errors->first('state') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <div class="form-group row @error('country') has-error @enderror">
                                <label for="country" class="col-sm-4 control-label">{{ __('Country') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="country" id="country" value="{{ $customerInfo->country }}" placeholder="Country">
                                    @if($errors->has('country'))
                                        <p class="text-danger">{{ $errors->first('country') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>

                          <div class="col-sm-6">
                              <div class="form-group row @error('phone') has-error @enderror">
                                <label for="phone" class="col-sm-4 control-label">{{ __('Phone Number') }}<span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                  <input type="text" class="form-control" name="phone" id="phone" maxlength="13" value="{{ $customerInfo->phone }}" placeholder="Example : 012 345 6789" />
                                  @if($errors->has('phone'))
                                        <p class="text-danger">{{ $errors->first('phone') }}</p>
                                    @endif
                                </div>
                            </div>
                          </div>
                          <div class="col-sm-6">      
                            <div class="form-group row @error('company_name') has-error @enderror">
                                <label for="company_name" class="control-label col-sm-4">{{ __('Company Name') }} <span class="text-danger">*</span></label></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="company_name" id="company_name" maxlength="13" value="{{ $customerInfo->company_name }}" placeholder="Company Name" required />
                                    @if($errors->has('company_name'))
                                        <p class="text-danger">{{ $errors->first('company_name') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                      <div class="col-sm-6">
                        <div class="form-group row @error('status') has-error @enderror">
                            <label for="status" class="control-label col-sm-4"> {{ __('Status') }} <span class="text-danger">*</span></label>                                
                            <div class="col-sm-8">
                              {!! Form::select('status', $status, $customerInfo->status, ['class' => 'form-control m-bot15']) !!}
                                @if($errors->has('status'))
                                    <p class="text-danger">{{ $errors->first('status') }}</p>
                                @endif
                            </div>
                        </div>
                    </div>
                    </div>
                        <div class="form-group row" style="text-align: center;">
                            <div class="col-sm-12">
                                <button type="submit" id="customerEditBtn" class="btn btn-primary">{{ __('Update Customer') }}</button>
                                <a href="{{ route('merchant.customer.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </form>
                  </div>
              </div>
          </div>
        </div>
      </div>
  </section>

<!-- page end-->
@endsection
@section('scripts')
<!-- Select2 -->
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>
<script>
  $('.select2').select2()
 $('.select2bs4').select2({
      theme: 'bootstrap4'
    })
   

</script>
@endsection