@extends('layouts.layout-admin')
@section('styles')
 <!-- Select2 -->
 <link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
 <link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
<style>
.control-label{
    text-align: right;
}
.hide{
    display: none;
}
</style>
@endsection
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Create Sales Person') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Create Sales Person') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Create Sales Person') }}</h3>                  
                  <span class="tools" style="float:right">
                    <a href="{{ route('merchant.sales-person.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                  </span>
                </div>
                <!-- /.card-header -->
                <div class="card-body">  
                           
                
                <form id="sales_person_add_form" autocomplete="off" role="form" enctype="multipart/form-data" method="POST" action="{{ route('merchant.sales-person.store') }}">
                    @csrf
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group row @error('first_name') has-error @enderror">                                
                                <label for="first_name" class="control-label col-sm-4"> {{ __('First Name') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">    
                                    <input type="text" class="form-control" name="first_name" id="first_name" placeholder="First Name" required>
                                    @if($errors->has('first_name'))
                                        <p class="text-danger">{{ $errors->first('first_name') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group row @error('last_name') has-error @enderror">                                
                                <label for="last_name" class="control-label col-sm-4"> {{ __('Last Name') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">    
                                    <input type="text" class="form-control" name="last_name" id="last_name" placeholder="Last Name" required>
                                    @if($errors->has('last_name'))
                                        <p class="text-danger">{{ $errors->first('last_name') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group row @error('email') has-error @enderror">
                                <label for="email" class="control-label col-sm-4">{{ __('Email') }} <span class="text-danger">*</span></label>
                                <div class="col-sm-8">
                                    <input type="email" class="form-control" name="email" id="email" placeholder="Email" required>
                                    @if($errors->has('email'))
                                        <p class="text-danger">{{ $errors->first('email') }}</p>
                                    @endif
                                </div>
                            </div>  
                        </div>
                        
                        <div class="col-lg-6">
                            <div class="form-group row @error('phone') has-error @enderror">
                                <label for="phone" class="control-label col-sm-4">{{ __('Phone Number') }} <span class="text-danger">*</span></label></label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="phone" id="phone" maxlength="13" value="{{Request::old('phone')}}" placeholder="Example : 012 345 6789" required />
                                    @if($errors->has('phone'))
                                        <p class="text-danger">{{ $errors->first('phone') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group row @error('password') has-error @enderror">
                                <label for="password" class="control-label col-sm-4">{{ __('Password') }}<span class="text-danger">*</span></label>                                
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" name="password" id="password" maxlength="13" value="{{$password}}" placeholder="Password" required />
                                    @if($errors->has('password'))
                                        <p class="text-danger">{{ $errors->first('password') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                    </div>
                    <div class="form-group row" style="text-align:center;">
                        <div class="col-sm-12" >
                            <button type="submit" id="salesPersonAddBtn" class="btn btn-primary">{{ __('Add Sales Person') }}</button>
                            <a href="{{ route('merchant.sales-person.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                        </div>
                    </div>
                </form>
                </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
@section('scripts')
<!-- Select2 -->
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>

<script>
  $(function () {
   
    $('input').attr('autocomplete','off');
 //Initialize Select2 Elements
$('.select2').select2()
   
  })

</script>
@endsection