<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Market;
use DataTables;
use Validator;

class MarketController extends Controller
{
    public function __construct()
    {
        $this->marketStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = Market::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("market_name", function ($data) {
                    if (empty($data->market_name)) {
                        return "N/A";
                    }
                    return $data->market_name;
                })
                ->addColumn("market_code", function ($data) {
                    if (empty($data->market_code)) {
                        return "N/A";
                    }
                    return $data->market_code;
                })
                ->addColumn("priority", function ($data) {
                    if (empty($data->priority)) {
                        return "N/A";
                    }
                    return $data->priority;
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-info">Action</button>
                        <button type="button" class="btn btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletemarket" href="javascript:;" data-market="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Market";
        return view("pages.admin.market.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $market = Market::find($request->id);
        $market->is_deleted = 1;
        $market->deleted_at = date('Y-m-d H:i:s');
        $market->save();
        return response()->json(['status' => 'success', 'message' => 'Market information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data = array();
        $data["status"] = $this->marketStatus;
        return view('pages.admin.market.ajaxAdd',$data);
    }
    public function addMarket(Request $request)
    {
        $messages = array(
                        'market_name.required' => 'Country Name is Required',
                        'market_name_ar.required' => 'Country Name(AR) is Required',
                    );
        $validator = Validator::make($request->all(), [
                                                'market_name' => 'required',
                                                'market_name_ar' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $market = Market::create([  
                "market_name" => trim($request->market_name),
                "market_name_ar" => trim($request->market_name_ar),
                "market_code" => trim($request->market_code),
                "priority" => trim($request->priority),
                "associated_countries" => trim($request->associated_countries),
                "status" => trim($request->status)
            ]);
            return response()->json(['status' => 'success', 'message' => 'Market added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $marketInfo = Market::find($request->market_id);
        $data["marketInfo"] = $marketInfo;
        $data["status"] = $this->marketStatus;
        return view('pages.admin.market.ajaxEdit',$data);
    }
    public function editMarket(Request $request)
    {
        $messages = array(
                        'market_name.required' => 'Country Name is Required',
                        'market_name_ar.required' => 'Country Name(AR) is Required',
        );
        $validator = Validator::make($request->all(), [
                                            'market_name' => 'required',
                                            'market_name_ar' => 'required',
                                            ], $messages);

        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $market = Market::find($request->market_id);
            $market->market_name = trim($request->market_name);
            $market->market_name_ar = trim($request->market_name_ar);
            $market->market_code = trim($request->market_code);
            $market->priority = trim($request->priority);
            $market->associated_countries = trim($request->associated_countries);
            $market->status = trim($request->status);
            $market->save();

            return response()->json(['status' => 'success', 'message' => 'Market updated successfully.', 'error' => ''], 200);
        }
    }
}
