<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Supplement;
use DataTables;
use Validator;

class SupplementController extends Controller
{
    public function __construct()
    {
        $this->supplementStatus = ["1" => "Active", "2" => "Inactive"];
        $this->supplementType = ["1" => "Per Person", "2" => "Per Night"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $results = Supplement::isNotDeleted()->get();
            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("supplement_name", function ($data) {
                    if (empty($data->supplement_name)) {
                        return "N/A";
                    }
                    return $data->supplement_name;
                })
                ->addColumn("supplement_code", function ($data) {
                    if (empty($data->supplement_code)) {
                        return "N/A";
                    }
                    return $data->supplement_code;
                })
                ->addColumn("supplement_type", function ($data) {
                    if (empty($data->supplement_type)) {
                        return "N/A";
                    }
                    return $this->supplementType[$data->supplement_type];
                })
                ->addColumn("status", function ($data) {
                    return ($data->status == 1)?'Active' : 'Inactive';
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                        <button type="button" class="btn btn-sm btn-info">Action</button>
                        <button type="button" class="btn btn-sm btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                          <span class="sr-only">Toggle Dropdown</span>
                        </button>
                        <div class="dropdown-menu" role="menu">
                          <a class="dropdown-item" href="javascript:;" onclick="ajaxEdit(' . $data->id . ');">Edit</a>
                          <a class="dropdown-item deletesupplement" href="javascript:;" data-supplement="' . $data->id . '">Delete</a>
                        </div>
                      </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage Supplement";
        return view("pages.admin.supplement.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $supplement = Supplement::find($request->id);
        $supplement->is_deleted = 1;
        $supplement->deleted_at = date('Y-m-d H:i:s');
        $supplement->save();
        //$supplement->delete();
        return response()->json(['status' => 'success', 'message' => 'Supplement information deleted successfully', 'error' => ''], 200);
    }

    public function ajaxAdd(Request $request)
    {
        $data["status"] = $this->supplementStatus;
        $data["supplement_type"] = $this->supplementType;
        return view('pages.admin.supplement.ajaxAdd',$data);
    }
    public function addSupplement(Request $request)
    {
        $messages = array(
                    'supplement_name.required' => 'Supplement Name is Required',
                    'supplement_name_ar.required' => 'Supplement Name(AR) is Required',
                );
        $validator = Validator::make($request->all(), ['supplement_name' => 'required', 'supplement_name_ar' => 'required'], $messages);
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $supplement = Supplement::create([            
                "supplement_name" => trim($request->supplement_name),
                "supplement_name_ar" => trim($request->supplement_name_ar),
                "supplement_code" => trim($request->supplement_code),
                "supplement_type" => trim($request->supplement_type),
                "status" => trim($request->status),
            ]);
            return response()->json(['status' => 'success', 'message' => 'Supplement added successfully.', 'error' => ''], 200);
        }
    }
    public function ajaxEdit(Request $request)
    {
        $supplementInfo = Supplement::find($request->supplement_id);
        $data["supplementInfo"] = $supplementInfo;
        $data["status"] = $this->supplementStatus;
        $data["supplement_type"] = $this->supplementType;
        return view('pages.admin.supplement.ajaxEdit',$data);
    }
    public function editSupplement(Request $request)
    {
        $messages = array(
                    'supplement_name.required' => 'Supplement Name is Required',
                    'supplement_name_ar.required' => 'Supplement Name(AR) is Required',
                );
        $validator = Validator::make($request->all(), ['supplement_name' => 'required', 'supplement_name_ar' => 'required'], $messages);
        if ($validator->fails()) {
            return response()->json(['status' => 'failed', 'error' => $validator->errors()], 200);
        }else{
            $supplement = Supplement::find($request->supplement_id);
            $supplement->supplement_name = trim($request->supplement_name);
            $supplement->supplement_name_ar = trim($request->supplement_name_ar);
            $supplement->supplement_code = trim($request->supplement_code);
            $supplement->supplement_type = trim($request->supplement_type);
            $supplement->status = trim($request->status);
            $supplement->save();

            return response()->json(['status' => 'success', 'message' => 'Supplement updated successfully.', 'error' => ''], 200);
        }
    }
}
