<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\QueryException;
use App\Models\User;
use App\Models\Supplier;
use App\Models\Service;
use App\Models\SupplierService;
use App\Models\supplierUserService;
use Spatie\Permission\Models\Role;
use DataTables;
use Session;

class UserController extends Controller
{
    public function __construct()
    {
        $this->userStatus = ["1" => "Active", "2" => "Inactive"];
        $this->defaultPassword = "Extra@123";
        $this->isApproved = ["0" => "Pending", "1" => "Approved","2"=>"Rejected"];
        $this->supplierStatus = ["1" => "Active", "2" => "Inactive"];
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
            
        if ($request->ajax()) {
            
            $results = User::isNotDeleted()->get();

            return DataTables::of($results)
                ->addIndexColumn()
                ->addColumn("user_name", function ($data) {
                    if (empty($data->user_name)) {
                        return "N/A";
                    }
                    return $data->user_name;
                })
               
                ->addColumn("email", function ($data) {
                    if (empty($data->email)) {
                        return "N/A";
                    }
                    return $data->email;
                })
                ->addColumn("role", function ($data) {
                    if (empty($data->role)) {
                        return "N/A";
                    }
                    return $data->role;
                })
                ->addColumn("action", function ($data) {
                    $btn =
                        '<div class="btn-group">
                            <button type="button" class="btn btn-sm btn-info">Action</button>
                            <button type="button" class="btn btn-sm btn-info dropdown-toggle dropdown-icon" data-toggle="dropdown">
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <div class="dropdown-menu" role="menu">
                                <a class="dropdown-item" href="' . route("user.edit", $data->id) . '">Edit</a>
                                <a class="dropdown-item deleteuser" href="javascript:;" data-user="' . $data->id . '">Delete</a>
                            </div>
                        </div>';
                    return $btn;
                })
                ->rawColumns(["action"])
                ->make(true);
        }
        $data["title"] = "Manage User";
        return view("pages.admin.user.list", $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data["roles"] = Role::where('name', '!=', 'SUPPLIER')->get();
        $data["password"] = $this->defaultPassword;
        $data["supplierList"] = Supplier::isNotDeleted()->get();
        return view('pages.admin.user.create',$data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            "user_name" => "required|regex:/^[a-zA-Z0 ]*$/|max:30",
            "email" => "required|email|unique:users,email",
            "password" => "required",           
            "role" => "required",
        ]);
        $password = Hash::make($request->password);
        try
        {
            if($request->role == 'SUPPLIEREMP'){
                $supplier_user_id = $request->supplier_user_id;
            }else{
                $supplier_user_id = 0;
            }
            $user = User::create([            
                "user_name" => trim($request->user_name),
                "email" => trim($request->email),                
                "password" => $password,
                "role" => $request->role,
                "supplier_user_id" => $supplier_user_id,
            ]);

            $user->assignRole($request->role);
            $service_ids = $request->service_name;
            if($service_ids && $request->role == 'SUPPLIEREMP'){
                foreach($service_ids as $service_id) {
                    supplierUserService::updateOrCreate(['supplier_user_id' => $supplier_user_id, 'service_id' => $service_id, 'user_id' => $user->id],['supplier_user_id' => $supplier_user_id, 'service_id' => $service_id, 'user_id' => $user->id]);
                }
            }
        }
        catch(QueryException $ex) 
        {
            return redirect()
                ->route("user.index")
                ->with("failed", $ex->getMessage());                 
        }       
        return redirect()
            ->route("user.index")
            ->with("success", "User created successfully!");
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $userInfo = User::where("id", "=", $id)->first();
        $data["userInfo"] = $userInfo;
        $data["roles"] = Role::all();
        $data["serviceList"]  = SupplierService::Where('user_id', $userInfo->supplier_user_id)->get();
        $data["supplierList"] = Supplier::isNotDeleted()->get();
        return view('pages.admin.user.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            "user_name" => "required|unique:users,user_name," . $id . "|regex:/^[a-zA-Z0 ]*$/|max:30",
            "email" => "required|email|unique:users,email," . $id . "",
            "role" => "required",
        ]);
        try
        {
            $user = User::find($id);
            $user->user_name = $request->user_name;
            $user->email = $request->email;            
            $user->role = $request->role;
            if($request->role == 'SUPPLIEREMP'){
                $user->supplier_user_id = $request->supplier_user_id;
            }
            $user->save();
            $user->syncRoles($request->role);

            $service_ids = $request->service_name;
            if($service_ids && $request->role == 'SUPPLIEREMP'){
                //supplierUserService::Where('user_id', $id)->where('supplier_user_id',$request->supplier_user_id)->delete();
                supplierUserService::Where('user_id', $id)->delete();
                foreach($service_ids as $service_id) {
                    supplierUserService::updateOrCreate(['supplier_user_id' => $request->supplier_user_id, 'service_id' => $service_id, 'user_id' => $id],['supplier_user_id' => $request->supplier_user_id, 'service_id' => $service_id, 'user_id' => $id]);
                }
            }
        }
        catch(QueryException $ex) 
        {
            return redirect()
                ->route("user.index")
                ->with("failed", "update error");                 
        } 
        
        return redirect()
            ->route("user.index")
            ->with("success", "User updated successfully!");

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $user = User::find($request->id);
        $user->delete();
        Session::flash("success", "User information deleted successfully.");
        return 1;
    }
    public function editProfileForm()
    {
        //if(\Auth::user()->can('edit profile'))
        //{
            if(\Auth::user()->role == "SUPPLIER")
            {
                //$supplierInfo = Supplier::where('supplier_id', \Auth::user()->supplier->supplier_id)->first();
                $supplierInfo = '';
                // if (!$supplierInfo)
                // {
                //     return redirect()->route('supplier.index');
                // }
                $data['supplier_id'] = '';
                $data['supplierInfo'] = $supplierInfo;

                $data["status"] = $this->supplierStatus;
                $data["namePrefix"] = array('1' => 'Mr', '2' => 'Mrs');
                $data["password"] = $this->defaultPassword;
                return view('pages.admin.supplier.edit-profile',$data);
            }
            else
            {
                return view('pages.admin.user.edit-profile');
            }
        // }
        // else
        // {
        //     return redirect()->back()->with('error', __('Permission denied.'));
        // }
        
    }

    public function getSupplierServiceList(Request $request){
        $serviceList = SupplierService::Where('user_id', $request->supplier_user_id)->get();
        $str ='<label class="col-lg-4 col-sm-4 control-label" for="supplier_servie">Supplier Service <span class="text-danger">*</span></label>
                <div class="col-lg-8">';
                        if($serviceList){
                            foreach($serviceList as $service){
                                $isExist = supplierUserService::Where('supplier_user_id',$request->supplier_user_id)->where('user_id', $request->user_id)->where('service_id', $service->service_id)->first();
                                $str .= '<div class="col-sm-12"><input type="checkbox" '.(($isExist)? 'checked' : '').' name="service_name[]" id="service_name_'.$service->service_id.'" class="services" value="'.$service->service_id.'"> <label for="service_name_'.$service->service_id.'">'.$service->service->service_name.'<label></div>';
                            }
                        }
            $str .= '</div>';
        return $str;
    }
}
