<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\Merchant;
use Auth;
use App\Events\LoginHistory;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    // protected $redirectTo = RouteServiceProvider::HOME;
    protected $redirectTo = RouteServiceProvider::DASHBOARD;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        // $this->middleware('auth:web');
    }
    //Merchant Login Form
    public function showMerchantLoginForm()
    {
        return view('auth.merchant-login');
    }
    //Merchant Login 
    public function merchantLogin(Request $request)
    {
        $this->validate(
            $request, [
                        'email' => 'required|email',
                        'password' => 'required|min:6',
                    ]
        );
        
        // if(\Auth::guard('merchant')->attempt(
        if(\Auth::attempt(
            [
                'email' => $request->email,
                'password' => $request->password,
            ]
        ))
        {
            
            
          
            // if(\Auth::guard('merchant')->user()->is_active == 0)
            // {
            //     \Auth::guard('merchant')->logout();
            // }

            return redirect()->route('merchant.dashboard');
        }

        return $this->sendFailedLoginResponse($request);
    }

    function authenticated(Request $request, $user)
    {
        if(\Auth::user()->is_approved != 1) {
            \Auth::logout();
            return redirect('/login')->with('status', 'Your account is not Approved, Please contact with admin');
            // return redirect()->back()->with('error', __('Permission denied.'));
        }
        $user->update([
            'last_login_at' => date('Y-m-d H:i:s'),
            'last_login_ip' => $request->getClientIp(),
            'user_agent' => $request->server('HTTP_USER_AGENT')
        ]);
        $loginUser = Auth::user();

        event(new LoginHistory($loginUser));
    }
}
