<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $primaryKey = 'setting_id';

    protected $guarded = [];

    public function scopeIsNotDeleted($query) 
    {
        return $query->where('is_deleted','!=',1);
    }
    
    public static function getSettingValue($setting_name)
    {
        $setting = Setting::where('setting_name',$setting_name)->first();   
        return $setting->setting_value;
    }
    public function unit()
    {
        return $this->hasOne('App\Models\Unit','unit_id','unit_id');
    }
}
