<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_facilities', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('hotel_facility_name');
            $table->string('hotel_facility_name_ar');
            $table->string('hotel_facility_code');
            $table->integer('hotel_section_type')->default(0);
            $table->text('hotel_facility_desc');
            $table->text('hotel_facility_desc_ar');
            $table->integer('status')->default(0); 
            $table->tinyInteger('is_deleted')->default(0);
            $table->dateTime('deleted_at')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_facilities');
    }
};
