<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contact_types', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('contact_type_name');
            $table->string('contact_type_name_ar');
            $table->string('contact_type_code');
            $table->integer('status')->default(0); 
            $table->tinyInteger('is_deleted')->default(0);
            $table->dateTime('deleted_at')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contact_types');
    }
};
