<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
   <!-- CSRF Token -->
   <meta name="csrf-token" content="{{ csrf_token() }}">

   <title>{{ config('app.name', 'Laravel') }}</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="{{ asset('plugins/fontawesome-free/css/all.min.css') }}">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- Tempusdominus Bootstrap 4 -->
  <link rel="stylesheet" href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
  <!-- iCheck -->
  <link rel="stylesheet" href="{{ asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
  <!-- JQVMap -->
  {{-- <link rel="stylesheet" href="{{ asset('plugins/jqvmap/jqvmap.min.css') }}"> --}}
  <!-- Theme style -->
  <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="{{ asset('plugins/overlayScrollbars/css/OverlayScrollbars.min.css') }}">
  <!-- Daterange picker -->
  <link rel="stylesheet" href="{{ asset('plugins/daterangepicker/daterangepicker.css') }}">
  <!-- summernote -->
  <link rel="stylesheet" href="{{ asset('plugins/summernote/summernote-bs4.min.css') }}">
    <!-- Toastr -->
    <link rel="stylesheet" href="{{ asset('plugins/toastr/toastr.min.css')}}">
  @yield('styles')
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <div id="app">
            <div class="wrapper">

                <!-- Preloader -->
                <div class="preloader flex-column justify-content-center align-items-center">
                  <img class="animation__shake" src="{{ asset('dist/img/AdminLTELogo.png') }}" alt="AdminLTELogo" height="60" width="60">
                </div>

                @include('includes.header')

                @include('includes.sidebar')

                <!-- Content Wrapper. Contains page content -->
                <div class="content-wrapper">
                  @yield('content')
                </div>
                <!-- /.content-wrapper -->

                @include('includes.footer')

                  <!-- Control Sidebar -->
                  <aside class="control-sidebar control-sidebar-dark">
                    <!-- Control sidebar content goes here -->
                  </aside>
                  <!-- /.control-sidebar -->

            </div>
            <!-- ./wrapper -->


    </div>
    <div class="modal fade" id="modal-xl-map" data-keyboard="false" data-backdrop="static">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h4 class="modal-title"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body m-2" id="getCode" style="height: 500px;">
          </div>
          <div class="modal-footer">
            {{-- <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> --}}
            <button type="button" class="btn btn-primary " data-dismiss="modal">{{ __('Submit') }}</button>
          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modal_title"></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
            </div>
            <div class="modal-body" id="modal_body"></div>
            <div class="modal-footer" id="modal_footer">
                <button data-dismiss="modal" class="btn btn-default" type="button">{{ __('Close') }}</button>
                <button class="btn btn-success" type="button">{{ __('Save changes') }}</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal_lg" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title" id="modal_lg_title"></h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body" id="modal_lg_body"></div>
        <div class="modal-footer justify-content-between" id="modal_lg_footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary">Save changes</button>
        </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>

<div class="modal fade" id="modal-xl-schedule" data-keyboard="false" data-backdrop="static">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title-schedule"></h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body m-2"  style="height: 500px;">
        <div id="getSchedule"></div>
        <div class="pt-3 text-right">
          <span class="title">{{ __('Total Pickup Quantity :') }}</span>
          <span id="total_pickup_quantity"></span>
        </div>
        <div class="pt-3 text-right">
          <span class="title">{{ __('Total Orders :') }}</span>
          <span id="total_orders"></span>
        </div>
      </div>
      <div class="modal-footer">
        
      </div>
    </div>
    <!-- /.modal-content -->
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- jQuery -->
<script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
<!-- jQuery UI 1.11.4 -->
<script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js') }}"></script>
<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>
<!-- Bootstrap 4 -->
<script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
<!-- ChartJS -->
<script src="{{ asset('plugins/chart.js/Chart.min.js') }}"></script>
<!-- Sparkline -->
<script src="{{ asset('plugins/sparklines/sparkline.js') }}"></script>
<!-- JQVMap -->
{{-- <script src="{{ asset('plugins/jqvmap/jquery.vmap.min.js') }}"></script>
<script src="{{ asset('plugins/jqvmap/maps/jquery.vmap.usa.js') }}"></script> --}}
<!-- jQuery Knob Chart -->
<script src="{{ asset('plugins/jquery-knob/jquery.knob.min.js') }}"></script>
<!-- daterangepicker -->
<script src="{{ asset('plugins/moment/moment.min.js') }}"></script>
<script src="{{ asset('plugins/daterangepicker/daterangepicker.js') }}"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
<!-- Summernote -->
<script src="{{ asset('plugins/summernote/summernote-bs4.min.js') }}"></script>
<!-- overlayScrollbars -->
<script src="{{ asset('plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js') }}"></script>
<!-- Toastr -->
<script src="{{ asset('plugins/toastr/toastr.min.js')}}"></script>
<!-- AdminLTE App -->
<script src="{{ asset('dist/js/adminlte.js') }}"></script>
<!-- AdminLTE for demo purposes -->
<script src="{{ asset('dist/js/demo.js') }}"></script>

<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
{{-- <script src="{{ asset('dist/js/pages/dashboard.js') }}"></script> --}}
@yield('scripts')
<script>

  //phone validation
  $('#phone,#company_phone,#postal_code,#ssm_number,#company_phone,#no_of_sales_person,#postal_code_1,#postal_code_2,#min_size_in_cm,#max_size_in_cm,#merchant_cost_in_rm,#driver_price_in_rm,#driver_price_in_perc').keypress(function(event) {
    const isNumber =/^[0-9]+$/i.test(event.key);
    if(!isNumber){
        event.preventDefault();
    }
    return isNumber;
});
//alphabet validation
$('#first_name,#last_name,#name,#user_name,#city,#state,#country,#country_1,#state_1,#city_1,#city_2,#state_2,#country_2').keypress(function(e) {
    const isLetter = /^[a-zA-Z0 ]*$/i.test(e.key);
    if(!isLetter){
        e.preventDefault();
    }
    return isLetter;
});

$('#company_name').keypress(function(e) {
  const isLetter = /^[A-Za-z0-9]*$/i.test(e.key);
    if(!isLetter){
        e.preventDefault();
    }
    return isLetter;
});
//role validation
$('#role_name').keypress(function(e) {
    const isLetter = /^[a-zA-Z0]*$/i.test(e.key);
    if(!isLetter){
        e.preventDefault();
    }
    return isLetter;
});
//licensce,id card validation
$('#ic_number,#license_number').keypress(function(e) {
    const isLetter = /(^[A-Za-z0-9]+$)+/i.test(e.key);
    if(!isLetter){
        e.preventDefault();
    }
    return isLetter;
});
//email validation
$('#email,#company_email').on('keypress', function() {
    $('span.error-keyup').remove();
    const isEmail = /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{1,2}|[0-9]{1,3})(\]?)$/.test(this.value);
    // const isEmail = /^[-a-z0-9~!$%^&*_=+}{\'?]+(\.[-a-z0-9~!$%^&*_=+}{\'?]+)*@([a-z0-9_][-a-z0-9_]*(\.[-a-z0-9_]+)*\.(aero|arpa|biz|com|coop|edu|gov|info|int|mil|museum|name|net|org|pro|travel|mobi|my|[a-z][a-z])|([0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}))(:[0-9]{1,5})?$/i.test(this.value);
    if(!isEmail){
        $(this).after('<span class="text-danger error-keyup">Invalid Email Format.</span>');
    }
})

  </script>

  @if ($message = Session::get('success'))
    <script>
      toastr.success('{!! $message !!}')
    </script>
  @endif
  @if ($message = Session::get('error'))
    <script>
      toastr.error('{!! $message !!}')
    </script>
  @endif
  @if ($message = Session::get('failed'))
    <script>
      toastr.error('{!! $message !!}')
    </script>
  @endif
  @if ($message = Session::get('info'))
    <script>
      toastr.info('{!! $message !!}')
    </script>
  @endif
  @if ($message = Session::get('warning'))
    <script>
      toastr.warning('{!! $message !!}')
    </script>
  @endif
</body>
</html>
