@extends('layouts.layout-admin')
@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1>{{ __('Setting') }}</h1>
      </div>
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
          <li class="breadcrumb-item active">{{ __('Setting') }}</li>
        </ol>
      </div>
    </div>
  </div><!-- /.container-fluid -->
</section>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                  <h3 class="card-title">{{ __('Manage Setting') }}</h3>
                  
                </div>
                <!-- /.card-header -->
              <div class="card-body">                             
                {{Form::model($settings,array('route'=>'admin.setting','method'=>'post'))}}
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-3 @error('status') has-error @enderror">
                            {{Form::label('admin_contact_number *',__('Admin Contact Number')) }}
                            <span class="text-danger">*</span>
                            {{Form::text('admin_contact_number',null,array('class'=>'form-control font-style'))}}
                            @if($errors->has('admin_contact_number'))
                            
                                <strong class="text-danger">{{$errors->first('admin_contact_number') }}</strong>
                            
                            @endif
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-3 @error('status') has-error @enderror">
                            {{Form::label('est_time_limit *',__('Estimated Time Limit')) }}
                            <span class="text-danger">*</span>
                            {{Form::text('est_time_limit',null,array('class'=>'form-control font-style'))}}
                            @if($errors->has('est_time_limit'))                            
                                <strong class="text-danger">{{$errors->first('est_time_limit') }}</strong>                            
                            @endif
                        </div>
                        
                        
                    </div>
                </div>
                <div class="card-footer text-right">
                    {{Form::submit(__('Save Change'),array('class'=>'btn btn-primary'))}}
                </div>
                {{Form::close()}}
              </div>
            </div>
        </div>
      </div>
    </div>
</section>
<!-- page end-->
@endsection
