@extends('layouts.layout-admin')

@section('content')
<!-- page start-->
 <!-- Content Header (Page header) -->
 <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>{{ __('Edit User') }}</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">{{ __('Home') }}</a></li>
            <li class="breadcrumb-item active">{{ __('Edit User') }}</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card">
                  <div class="card-header">
                    <h3 class="card-title">{{ __('Edit Users') }}</h3>                  
                    <span class="tools" style="float:right">
                      <a href="{{ route('user.index') }}" title="Back" class="btn btn-primary btn-sm"><i class="fa fa-reply"></i></a>
                    </span>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body"> 
                       
                    <form class="form-horizontal" id="user_edit_form" autocomplete="off" role="form" method="POST" action="{{ route('user.update', $userInfo->id ) }}">
                        @csrf
                        {{method_field('PUT')}}
                        
                        <div class="form-group @error('user_name') has-error @enderror">
                            <label for="user_name" class="col-lg-4 col-sm-4 control-label">{{ __('User Name') }} <span class="text-danger">*</span></label>
                            <div class="col-lg-8">
                                <input type="text" class="form-control" name="user_name" id="user_name" value="{{ $userInfo->user_name }}" placeholder="Name" required maxlength="30">
                                 @if($errors->has('user_name'))
                                    <p class="text-danger">{{ $errors->first('user_name') }}</p>
                                 @endif
                            </div>
                        </div>
                        <div class="form-group @error('email') has-error @enderror">
                            <label for="email" class="col-lg-4 col-sm-4 control-label">{{ __('Email') }} <span class="text-danger">*</span></label>
                            <div class="col-lg-8">
                                <input type="email" class="form-control" name="email" id="email" value="{{ $userInfo->email }}" placeholder="Email" required>
                                @if($errors->has('email'))
                                    <p class="text-danger">{{ $errors->first('email') }}</p>
                                @endif
                            </div>
                        </div>
                        
                        <div class="form-group @error('role') has-error @enderror">
                            <label class="col-lg-4 col-sm-4 control-label" for="role">Role <span class="text-danger">*</span></label>
                            <div class="col-lg-8">
                                <select id="role" name="role" class="form-control" @if("SUPPLIER" == $userInfo->role) readonly @endif>
                                    <option value="" disabled="disabled" selected> -- Select Role -- </option>
                                    @foreach($roles as $role)
                                        <option value="{{$role->name}}" @if($role->name == $userInfo->role) selected="selected" @endif>{{$role->name}}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('role'))
                                    <p class="text-danger">{{ $errors->first('role') }}</p>
                                @endif
                            </div>
                        </div>
                        <div class="form-group @error('supplier_user_id') has-error @enderror" id="supplierDiv" style="display:none;">
                            <label class="col-lg-4 col-sm-4 control-label" for="supplier_user_id">Supplier Name <span class="text-danger">*</span></label>
                            <div class="col-lg-8">
                                <select id="supplier_user_id" name="supplier_user_id" class="form-control">
                                    <option value="" disabled="disabled" selected> -- Select Supplier -- </option>
                                    @foreach($supplierList as $supplier)
                                        <option value="{{$supplier->user_id}}" @if($supplier->user_id == $userInfo->supplier_user_id) selected="selected" @endif>{{$supplier->supplier_company}} ({{$supplier->supplier_code}})</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group" id="serviceDiv" style="display:none;">
                            <label class="col-lg-4 col-sm-4 control-label" for="supplier_servie">Supplier Service <span class="text-danger">*</span></label>
                            <div class="col-lg-8">
                                @foreach($serviceList as $service)
                                    <div class="col-sm-12"><input type="checkbox" @if(App\Models\supplierUserService::Where('supplier_user_id', $userInfo->supplier_user_id)->where('user_id', $userInfo->id)->where('service_id', $service->service_id)->first()) checked @endif name="service_name[]" id="service_name_{{$service->service_id}}" class="services" value="{{$service->service_id}}"> <label for="service_name_{{$service->service_id}}">{{$service->service->service_name}}<label></div>
                                @endforeach
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="col-lg-offset-4 col-lg-8">
                            <input type="hidden" name="user_id" id="user_id" value="{{ $userInfo->id }}" />
                                <button type="button" onclick="validateForm();" id="userEditBtn" class="btn btn-primary">{{ __('Update User') }}</button>
                                <a href="{{ route('user.index') }}" class="btn btn-warning">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </form>
                  </div>
              </div>
          </div>
        </div>
      </div>
  </section>

<!-- page end-->
@endsection
@section('scripts')
<script type="text/javascript">
$(document).ready(function() {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    if($("#role").val() == 'SUPPLIEREMP'){
        $("#supplierDiv").show();
    }
    if($("#supplier_user_id").val()){
        $("#serviceDiv").show();
    }
});
$("#role").on('change', function() {
    if($("#role").val() == 'SUPPLIEREMP'){
        $("#supplierDiv").show();
        $("#serviceDiv").show();
    }else{
        $("#supplierDiv").hide();
        $("#serviceDiv").hide();
    }
});
$("#supplier_user_id").on('change', function() {
    if($("#supplier_user_id").val()){
        $.ajax({
            url: "{{ route('user.getSupplierServiceList') }}",
            data: {"supplier_user_id": $("#supplier_user_id").val(), "user_id": $("#user_id").val()},
            type: "post",
            dataType: "html",
            cache: false,
            success: function (html) {
                $("#serviceDiv").show();
                $( '#serviceDiv' ).html(html);
            }
        });
    }
});
function validateForm(){
    if($("#user_edit_form #role").val() == 'SUPPLIEREMP'){
        var supplier = $("#user_edit_form #supplier_user_id").val();
        if(supplier == "" || supplier == null){
            toastr.error('Please select the supplier.','Error');
            return false;
        }else{
            var service_name = [];
            $('.services:checked').each(function(){
                service_name.push($(this).val());
            });
            if(service_name == ""){
                toastr.error('Please select minimum one service.','Error');
                return false;
            }else{
                $('form#user_edit_form').submit();
            }
        }
    }else{
        $('form#user_edit_form').submit();
    }
}
</script>
@endsection